# Introduction
This is a simple library reading configuration files. The following formats
are supported:

* YAML
* INI
* JSON

# Use
You can include the library using composer.

# API
Below you see some sample usage of the API:

    // load a new config from a YAML file
    $c = new Config::fromYamlFile("file.yaml");

    // load a new config from a YAML file
    $i = new Config::fromIniFile("file.ini");

    // load a new config from a JSON file
    $j = new Config::fromJsonFile("file.json");

    // get the optional value for key "foo", default value is 1234 when the key 
    // "foo" does not exist
    $c->getLeaf("foo", false, 1234);

    // get the section "foo" of the configuration as a new Config object
    $d = $c->getSubtree("foo");
    
    // get the required value of the key "bar"
    $d->getLeaf("bar", true);

By default a section is not required. This behavior changed in version 0.2.0. 
Before, when requesting a section that didn't exist an exception was thrown, 
now there just won't be any leafs under it, but the API will continue to work.

# Examples
Suppose your configuration file is the following YAML file:

    foo:
        bar: { a: abc, b: bcd, c: cde }
        baz: [foo, bar, baz]

In order to fetch the value for `c` you would write the following:

    echo $c->getSubtree('foo')->getSubtree('bar')->getLeaf('c');

You can also use the following aliases:

    echo $c->s('foo')->s('bar')->l('c');

If you want to get all values from a subtree, you can use the following:

    print_r($c->s('foo')->s('baz')->toArray());
    
This only works on subtrees, not on leafs.

# License
Licensed under the Apache License, Version 2.0;

   http://www.apache.org/licenses/LICENSE-2.0
