# $Id: Root.pm 38161 2012-11-07 17:11:25Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Root.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Error;

use UvT::Squarepeg::Document -self;

field type;
field args;

use constant rootname => 'error';

sub build {
	my $root = $self->documentElement;

	$root->appendChild($self->construct(type => $self->type));

	my $args = $self->createElement('args');
	$root->appendChild($args);
	while(my ($key, $val) = each(%{$self->args})) {
		$args->appendChild($self->construct($key => $val));
	}
}

package UvT::Squarepeg::Root::Request;

use Xyzzy::Request -self;

sub errorpage {
    my ($type, %args) = @_;
	my $doc = new UvT::Squarepeg::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}

package UvT::Squarepeg::Root;

use UvT::Squarepeg::Handler -self;

sub handle {
	local $SIG{__DIE__} = sub { my $err = shift; die $err if ref $err || $err =~ /\n/; confess $err };
	my $req = new UvT::Squarepeg::Root::Request(cfg => $self, ctx => shift);
	my $res = eval { super($req) };
	return $res if defined $res;
	die $@ if ref $@;
	warn $@ if $@;
	die $req->errorpage('internal');
}
