# $Id: Quota.pm 33504 2011-01-13 15:47:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Quota.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Quota::Config;

use Xyzzy -self;
use Quota;

field quota_path => sub { die "no QuotaPath configured\n" };
field quota_projid => '/etc/projid';

sub set_quotapath {
	my $path = shift;
	die "QuotaPath '$path' does not exist\n"
		unless -e $path;
	my $qcarg = Quota::getqcarg($path)
		or die "Don't know how to interpret QuotaPath '$path'\n";
	$self->quota_path($qcarg);
}

*set_quotaprojid = *quota_projid;

package UvT::Squarepeg::Quota;

use Quota;
use IO::File;

use Clarity -self;

field cfg;
field quota_path => sub { shift->cfg->quota_path };
field quota_projid => sub { shift->cfg->quota_projid };
field projids => {};

sub readprojids {
	my $cfg = $self->cfg;

	my $projid = $cfg->quota_projid;

	my $fh = new IO::File($projid, '<')
		or die "open($projid): $!\n";

	my $projids = $self->projids;

	while(defined(my $line = $fh->getline)) {
		chomp $line;
		my ($box, $num) = split(/:/, $line);
		next unless defined $box && defined $num;
		die("Malformed line at $projid:".$fh->input_line_number."\n")
			unless $box ne '' && $num =~ /^(?:0|[1-9]\d*)$/;
		$projids->{$box} = int($num);
	}

	die "read($projid): $!\n" unless $fh->eof;
}

sub get {
	my $proj = shift;

	my $projids = $self->projids;

	if($proj =~ /^(?:0|[1-9]\d+)$/) {
		$proj = int($proj);
	} else {
		unless(exists $projids->{$proj}) {
			$self->readprojids;
			return unless exists $projids->{$proj};
		}
		$proj = $projids->{$proj};
	}

	my ($block_curr, $block_soft, $block_hard, $block_timelimit,
			$inode_curr, $inode_soft, $inode_hard, $inode_timelimit) =
		Quota::query($self->quota_path, $proj, 2);

	return unless defined $block_curr;

	return 1024 * $block_curr;
}
