# $Id: Portal.pm 38161 2012-11-07 17:11:25Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Portal.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Portal::Document;

use UvT::Squarepeg::Document -self;

use constant rootname => 'portal';

sub response {
	my $req = $self->req;
	my $res = super;
	if(!$req->is_admin) {
		$res->status(302);
		$res->setheader(Location => $req->script_url . '/user/' . $req->login);
	}
	return $res;
}

package UvT::Squarepeg::Portal;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $doc = new UvT::Squarepeg::Portal::Document(req => shift);
	return $doc->response;
}
