# $Id: Document.pm 38161 2012-11-07 17:11:25Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Document;

use Xyzzy::Document::XHTML -self;

sub build {
	my $name = $self->rootname;
	my $root = $self->createElement($name);
	$self->setDocumentElement($root);

	my $req = $self->req;
	my $uid = eval { $req->login }; 
	if(defined $uid) {
		$root->appendTextChild(login => $uid);

		$root->appendChild($self->createElement('admin'))
			if $req->is_admin;
	}

	$self->hook_next;

	eval { $self->transform($name) };
	warn $@ if $@;
}

sub response {
	my $res = super;
	my $req = $self->req;

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	# Don't try to second guess the content type
	$res->setheader('X-Content-Type-Options' => 'nosniff');

	# Protect against clickjacking
	$res->setheader('X-Frame-Options' => 'DENY');

	return $res;
}
