# $Id: Canonical.pm 33243 2010-12-03 15:14:02Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Canonical.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package UvT::Squarepeg::Canonical;

use Unicode::Normalize qw(NFC NFD NFKC NFKD compose decompose reorder);
use Exporter qw(import);

our @EXPORT = qw(canonical_identifier is_canonical_identifier canonical_name is_canonical_name);

sub canonical_identifier {
	local $_ = shift;
	return undef unless defined;
	$_ = lc;
	return undef unless /^[a-z0-9_]+([.-][a-z0-9_]+)*$/;
	return $_;
}

sub is_canonical_identifier {
	local $_ = shift;
	return undef unless defined;
	my $canon = canonical_identifier($_);
	return undef unless defined $canon;
	return $_ eq $canon;
}

sub canonical_name {
	local $_ = shift;
	return undef unless defined;
	$_ = NFC($_);
	$_ = ucfirst unless /[[:upper:]]/;
	s{[:/]}{ - }g;
	s/\s+/ /g;
	s/^ | $|\pC+//g;
	return undef if $_ eq '';
	return $_;
}

sub is_canonical_name {
	local $_ = shift;
	return undef unless defined;
	my $canon = canonical_name($_);
	return undef unless defined $canon;
	return $_ eq $canon;
}
