# $Id: Modify.pm 33786 2011-02-07 09:18:21Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Modify.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Modify::Request;

use UvT::Squarepeg::Canonical;

use UvT::Squarepeg::Ajax::User::Request -self;

param name => sub {
	my $self = shift;
	die $self->errorpage('missing_parameter', param => 'name') unless $_;
	$_ = canonical_name($_) // die $self->errorpage('malformed_parameter', param => 'name');
};

param admin => sub {
	die shift->errorpage('missing_parameter', param => 'admin') unless defined;
	$_ = $_ eq 'true';
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $uid = $self->uid;
	my $name = $self->name;
	my $admin = $self->admin;

	die $self->errorpage('permission_denied')
		unless $self->is_admin_for_user($uid);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailuser, name, admin FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	my $id = @$res && $res->[0][0];

	if($id) {
		die $self->errorpage('permission_denied')
			unless !$admin || $res->[0][2] || self->is_admin;
	} else {
		$q = $db->prepare_cached('SELECT name FROM mailboxes WHERE box = ?');
		$q->execute($uid);
		$res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			die $self->errorpage('box_exists', uid => $uid, box => $uid, name => $name // $uid, existing => $existing)
				if @$res;
		}
	}

	my $cn = $self->cfg->ldap->cn($uid);

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless $id || $cn;

	my $uniq = $name;
	for(my $i = 1;;) {
		$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?) AND box <> ?');
		$q->execute($uniq, $uid);
		$res = $q->fetchall_arrayref;
		$q->finish;
		last unless @$res;
		if($cn) {
			$uniq = $cn;
			undef $cn;
		} else {
			$uniq = "$name #".++$i;
		}
	}
	$name = $uniq;

	if($id) {
		$q = $db->prepare_cached('UPDATE mailboxes SET name = ? WHERE mailbox = ?');
		$q->execute($name, $id);
		$q->finish;

		if($self->is_admin) {
			$q = $db->prepare_cached('UPDATE mailusers SET admin = ? WHERE mailuser = ?');
			$q->execute($admin ? 't' : 'f', $id);
			$q->finish;
		}
	} else {
		$q = $db->prepare_cached('INSERT INTO mailboxes (box, name, quota) VALUES (?, ?, ?)');
		$q->execute($uid, $name, $self->cfg->defaultquota);
		$q->finish;

		$q = $db->prepare_cached('INSERT INTO mailusers (mailuser, admin) VALUES ((SELECT mailbox FROM mailboxes WHERE box = ?), ?)');
		$q->execute($uid, $admin && $self->is_admin ? 't' : 'f');
		$q->finish;
	}

	$db->commit;

	system($self->cfg->syncboxes);

	return [[uid => $uid], [name => $name], [admin => $admin ? 'true' : 'false']];
};

package UvT::Squarepeg::Ajax::User::Modify;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Modify::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

