# $Id: Modify.pm 33876 2011-02-14 14:06:57Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Box/Modify.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Box::Modify::Request;

use UvT::Squarepeg::Ajax::User::Box::Request -self;

param manager => sub {
	die shift->errorpage('missing_parameter', param => 'manager') unless defined;
	$_ = $_ eq 'true';
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $manager = $self->manager;

	my $box = $self->box;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('box_does_not_exist', box => $box)
		unless @$res;

	my ($mailbox) = @{$res->[0]};

	$q = $db->prepare_cached('SELECT name FROM mailnames WHERE mailuser = ?');
	$q->execute($mailbox);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('user_not_box', uid => $box, name => $res->[0][0])
		if @$res;

	die $self->errorpage('permission_denied')
		unless $self->is_manager_for_box($box);
	
	my $uid = $self->uid;

	$q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless @$res;

	my ($mailuser) = @{$res->[0]};

	$q = $db->prepare_cached('SELECT EXISTS (SELECT NULL FROM maillinks WHERE mailuser = ? AND mailbox = ?)');
	$q->execute($mailuser, $mailbox);
	$res = $q->fetchall_arrayref;
	$q->finish;

	if(@{$res->[0]}) {
		my $q = $db->prepare_cached('UPDATE maillinks SET manager = ? WHERE mailuser = ? AND mailbox = ?');
		$q->execute($manager ? 't' : 'f', $mailuser, $mailbox);
		$q->finish;
	} else {
		my $q = $db->prepare_cached('INSERT INTO maillinks (mailuser, mailbox, manager) VALUES (?, ?, ?)');
		$q->execute($mailuser, $mailbox, $manager ? 't' : 'f');
		$q->finish;
	}

	system($self->cfg->syncboxes);

	return [[uid => $uid], [box => $box], [manager => $manager ? 'true' : 'false']];
};

package UvT::Squarepeg::Ajax::User::Box::Modify;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Box::Modify::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}
