# $Id: Delete.pm 34010 2011-02-22 16:31:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/User/Box/Delete.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::User::Box::Delete::Request;

use UvT::Squarepeg::Ajax::User::Box::Request -self;

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $box = $self->box;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('box_does_not_exist', box => $box)
		unless @$res;

	my ($mailbox) = @{$res->[0]};

	my $uid = $self->uid;

	$q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($uid);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('uid_does_not_exist', uid => $uid)
		unless @$res;

	my ($mailuser) = @{$res->[0]};

	die $self->errorpage('permission_denied')
		unless $self->is_admin_for_user($uid) || $self->is_manager_for_box($box);
	
	$q = $db->prepare_cached('DELETE FROM maillinks WHERE mailuser = ? AND mailbox = ?');
	$q->execute($mailuser, $mailbox);
	$q->finish;

	$db->commit;

	system($self->cfg->syncboxes);

	return [[uid => $uid], [box => $box]];
};

package UvT::Squarepeg::Ajax::User::Box::Delete;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::User::Box::Delete::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}
