# $Id: List.pm 33786 2011-02-07 09:18:21Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Boxes/List.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Boxes::List::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok', map {
		my ($box, $name, $quota, $usage) = @$_;
		[mbox => [box => $box], [name => $name], [quota => $quota], [usage => $usage // 0]]
	} @{$req->boxes}));
}

package UvT::Squarepeg::Ajax::Boxes::List::Request;

use Xyzzy::Request -self;

field boxes => sub {
	my $self = shift;

	die $self->errorpage('permission_denied')
		unless $self->is_admin;

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT box, name, quota FROM mailboxes ORDER BY box');
	$q->execute;
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	my $quota = $self->cfg->quota;

	my @res = map {
			my ($box, $name, $limit) = @$_;
			my $usage = $quota->get($box);
			[$box, $name, $limit, $usage]
		} @$res;

	return \@res;
};

package UvT::Squarepeg::Ajax::Boxes::List;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Boxes::List::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Boxes::List::Document(req => $req);
	return $doc->response;
}
