# $Id: Modify.pm 34010 2011-02-22 16:31:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Modify.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Modify::Request;

use UvT::Squarepeg::Canonical;

use UvT::Squarepeg::Ajax::Box::Request -self;

param name => sub {
	my $self = shift;
	die $self->errorpage('missing_parameter', param => 'name') unless $_;
	$_ = canonical_name($_) // die $self->errorpage('malformed_parameter', param => 'name');
};

param quota => sub {
	my $self = shift;
	die $self->errorpage('missing_parameter', param => 'quota') unless defined;
	die $self->errorpage('malformed_parameter', param => 'quota') unless /^(?:0|[1-9]\d*)$/;
	$_ = int($_);
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $box = $self->box;
	my $name = $self->name;
	my $quota = $self->quota;
	my $login = $self->login;

	# als de box niet bestaat moet je admin zijn (om 'm aan te maken)
	die $self->errorpage('permission_denied')
		unless $self->is_manager_for_box($box);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailbox, name FROM mailboxes WHERE box = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	my $id = @$res && $res->[0][0];

	unless($id) {
		my $cn = $self->cfg->ldap->cn($box);
		die $self->errorpage('uid_exists_ldap', uid => $box, name => $name // $box, ldap => $cn)
			if $cn;
	}

	my $uniq = $name;
	for(my $i = 1;;) {
		$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?) AND box <> ?');
		$q->execute($uniq, $box);
		$res = $q->fetchall_arrayref;
		$q->finish;
		last unless @$res;
		$uniq = "$name #".++$i;
	}
	$name = $uniq;

	my $journal;
	if($id) {
		if($self->is_admin) {
			$q = $db->prepare_cached('UPDATE mailboxes SET name = ?, quota = ? WHERE mailbox = ?');
			$q->execute($name, $quota, $id);
			$q->finish;

			$q = $db->prepare_cached('INSERT INTO journal (subject, verb, object, value) VALUES (?, ?, ?, ?)');
			$q->execute($login, 'modify box', $box, "quota=$quota name=$name");
			$q->finish;

			$journal = "journal: $login modified mailbox $box: quota=$quota, name=$name\n";
		} else {
			$q = $db->prepare_cached('UPDATE mailboxes SET name = ? WHERE mailbox = ?');
			$q->execute($name, $id);
			$q->finish;

			$q = $db->prepare_cached('INSERT INTO journal (subject, verb, object, value) VALUES (?, ?, ?, ?)');
			$q->execute($login, 'modify box', $box, "name=$name");
			$q->finish;

			$journal = "journal: $login modified mailbox $box: name=$name\n";
		}
	} else {
		$q = $db->prepare_cached('INSERT INTO mailboxes (box, name, quota) VALUES (?, ?, ?)');
		$q->execute($box, $name, $quota);
		$q->finish;

		$q = $db->prepare_cached('INSERT INTO journal (subject, verb, object, value) VALUES (?, ?, ?, ?)');
		$q->execute($login, 'add box', $box, "name=$name");
		$q->finish;

		$journal = "journal: $login added mailbox $box: name=$name\n";
	}

	$db->commit;

	warn $journal if $journal;

	system($self->cfg->syncboxes);

	return [[box => $box], [name => $name], [quota => $quota]];
};

package UvT::Squarepeg::Ajax::Box::Modify;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Modify::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

