# $Id: Delete.pm 34010 2011-02-22 16:31:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Delete.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Delete::Request;

use UvT::Squarepeg::Ajax::Box::Request -self;

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $box = $self->box;

	die $self->errorpage('permission_denied')
		unless $self->is_manager_for_box($box);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailuser FROM mailnames WHERE uid = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('user_not_box', uid => $box)
		if @$res;

	$q = $db->prepare_cached('DELETE FROM mailboxes WHERE box = ?');
	$q->execute($box);
	$q->finish;

	my $login = $self->login;
	$q = $db->prepare_cached('INSERT INTO journal (subject, verb, object) VALUES (?, ?, ?)');
	$q->execute($login, 'delete box', $box);
	$q->finish;

	$db->commit;

	warn "journal: $login deleted mailbox $box\n";

	system($self->cfg->syncboxes);

	return [[box => $box]];
};

package UvT::Squarepeg::Ajax::Box::Delete;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Delete::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

