# $Id: ACL.pm 38161 2012-11-07 17:11:25Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/ACL.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::ACL::Request;

use Xyzzy::Request -self;

field is_admin => sub {
	my $self = shift;
	my $uid = $self->login;
	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT EXISTS(SELECT NULL FROM mailnames WHERE uid = ? AND admin)');
	$q->execute($uid);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res->[0][0];
};

sub is_admin_for_user {
	my ($uid) = @_;
	my $user = $self->login;
	return lc($user) eq $uid || $self->is_admin;
}

sub is_manager_for_box {
	return 1 if $self->is_admin;
	my $uid = $self->login;
	my $box = shift;
	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT EXISTS(SELECT NULL FROM mailnames JOIN maillinks USING (mailuser) JOIN mailboxes USING (mailbox) WHERE uid = ? AND mailboxes.box = ? AND maillinks.manager)');
	$q->execute($uid, $box);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res->[0][0];
}

sub has_access_to_box {
	return 1 if $self->is_admin;
	my $uid = $self->login;
	my $box = shift;
	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT EXISTS(SELECT NULL FROM mailnames JOIN maillinks USING (mailuser) JOIN mailboxes USING (mailbox) WHERE uid = ? AND mailboxes.box = ?)');
	$q->execute($uid, $box);
	my $res = $q->fetchall_arrayref;
	$q->finish;
	return $res->[0][0];
}

package UvT::Squarepeg::ACL;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $ctx = shift;
	$ctx->login;
	my $req = new UvT::Squarepeg::ACL::Request(cfg => $self, ctx => $ctx);
	return super($req);
}
