<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ss="http://tilburguniversity.edu/stylesheets">

	<xsl:param name="script_url"/>

	<xsl:template match="*" mode="head"/>

	<xsl:template match="/">
		<ss:root>
			<ss:head>
				<base href="{$script_url}/"/>
				<link rel="stylesheet" href="static/uvt.css" type="text/css"/>
				<script type="text/javascript" src="static/common.js"/>
				<xsl:apply-templates mode="head"/>
			</ss:head>

			<ss:keywords>mailboxen mailboxes mailbox mail box functioneel</ss:keywords>
			<ss:description>Tilburg University mail box management</ss:description>
			<ss:title><xsl:apply-templates mode="title"/> – Squarepeg</ss:title>

			<ss:colorbar>
				<ss:color>blue</ss:color>
				<ss:title>Squarepeg</ss:title>
				<ss:message>Manage access to your functional mail boxes</ss:message>
				<ss:panels>
					<ss:panel>
						<ss:link>manual</ss:link>
						<ss:image>static/lolwut.png</ss:image>
						<ss:message>Manual</ss:message>
						<ss:color>Green</ss:color>
					</ss:panel>
					<ss:panel>
						<ss:link>mailto:lis-unix@uvt.nl</ss:link>
						<ss:image>static/supdawg.png</ss:image>
						<ss:message>Contact us</ss:message>
						<ss:color>Grey</ss:color>
					</ss:panel>
				</ss:panels>
			</ss:colorbar>

			<!-- disabled
			<ss:languages>
				<ss:language>
					<ss:code>en</ss:code>
					<ss:target>javascript:setlang('en')</ss:target>
				</ss:language>
				<ss:language>
					<ss:code>nl</ss:code>
					<ss:target>javascript:setlang('nl')</ss:target>
				</ss:language>
			</ss:languages>
			-->

			<ss:content>
				<xsl:apply-templates/>
			</ss:content>
		</ss:root>
	</xsl:template>

	<!-- prevent extraneous text from showing up -->
	<xsl:template match="text()"/>
</xsl:stylesheet>
