// $Id: box.js 38168 2012-11-08 11:51:39Z wsl $
// $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/www/box.js $

window.onload = function() {
	var colinfo = new Array(
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_icon';
				var img = document.createElement('img');
				img.setAttribute('src', 'static/user-icon.png');
				img.setAttribute('alt', 'User');
				td.appendChild(img);
				return td;
			}
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_short';
				var a = document.createElement('a');
				a.setAttribute('href', 'user/' + vs.uid);
				UvT.setTableText(a, vs.uid);
				td.appendChild(a);
				return td;
			},
			function(td, vs) { vs.uid = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_long';
				UvT.setTableText(td, vs.name);
				return td;
			},
			function(td, vs) { vs.name = UvT.getText(td); }
		),
		new UvT.EditableColumn(
			function(vs) {
				var td = document.createElement('td');
				td.className = 'edit_manager';
				UvT.setTableText(td, vs.manager == 'true' ? 'manager' : '');
				return td;
			},
			function(td, vs) { vs.manager = UvT.getText(td) == 'manager' ? 'true' : 'false' },
			function(vs) {
				var inp = UvT.construct('input', {type: 'checkbox'});
				inp.checked = vs.manager == 'true';
				var td = UvT.construct('td', ['label', inp, 'manager?']);
				td.className = 'edit_manager';
				return td;
			},
			function(td, vs) { vs.manager = td.childNodes[0].childNodes[0].checked ? 'true' : 'false'; }
		)
	);

	UvT.getNonce();
	setInterval(UvT.getNonce, 60000);

	var box = top.location.pathname;
	box = box.substr(box.lastIndexOf('/') + 1).toLowerCase();
	if(!box.match(/^[a-z0-9_]+([.-][a-z0-9_]+)*$/))
		throw new Error("invalid username");

	var url = 'ajax/rest/boxes/'+box+'/users';

	var us = document.getElementById('userlist');
	var et = new UvT.EditableTable(us, url, colinfo, 'uid');

	var knopje = document.getElementById('addnewusers');
	var veldje = document.getElementById('newusers');

	function addedUsers(o) {
		var root = o.documentElement;
		if(root.tagName != 'ok') {
			et.showfail(root.tagName, UvT.deconstruct(root));
			return;
		}
		var raw = '';
		var rs = root.childNodes;
		for(var i = 0; i < rs.length; i++) {
			var r = rs[i];
			if(r.tagName == undefined)
				continue;
			var info = UvT.deconstruct(r);
			if(r.tagName == 'ok') {
				et.addrow(info);
			} else {
				if(info.uid != undefined) {
					if(info.uid == info.name)
						raw += info.uid + "\n";
					else
						raw += info.uid + " " + info.name + "\n";
				}
				et.showfail(r.tagName, info);
			}
		}
		veldje.value = raw;
	}

	function addUsers(raw) {
		var q = 'nonce=' + encodeURIComponent(window.nonce)
			+ '&raw=' + encodeURIComponent(raw);

		$.ajax({
			type: 'POST',
			url: url,
			data: q,
			success: addedUsers,
			timeout: 5000
		});

		et.clearfail();
	}

	knopje.onclick = function() { addUsers(veldje.value); };
};
