# $Id: Create.pm 38168 2012-11-08 11:51:39Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Boxes/Create.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Boxes::Create::Request;

use UvT::Squarepeg::Canonical;

use Xyzzy::Request -self;

param raw => sub {
	die shift->errorpage('missing_parameter', param => 'raw') unless $_;
};

field results => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	die $self->errorpage('permission_denied')
		unless $self->is_admin;

	my $login = $self->login;

	my @boxes =
		grep { @$_ }
		map { s/\s+/ /g; [split(' ', $_, 2)] }
		split(/\n/, $self->raw);

	my @results;
	my $journal = '';

	my $db = $self->db;
	foreach my $mailbox (@boxes) {
		my ($origbox, $name) = @$mailbox;
		my $box = canonical_identifier($origbox);
		$name = canonical_name($name);

		unless(defined $box) {
			push @results, ['error_box_invalid', [box => $origbox], [name => $name // $origbox]];
			next;
		}

		my $q = $db->prepare_cached('SELECT name FROM mailboxes WHERE box = ?');
		$q->execute($box);
		my $res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_box_exists', [box => $box], [name => $name // $box], [existing => $existing]];
			next;
		}

		$q = $db->prepare_cached('SELECT name FROM mailnames WHERE uid = ?');
		$q->execute($name);
		$res = $q->fetchall_arrayref;
		$q->finish;
		if(@$res) {
			my ($existing) = @{$res->[0]};
			push @results, ['error_uid_exists', [uid => $box], [name => $name // $box], [existing => $existing]];
			next;
		}

		my $cn = $self->cfg->ldap->cn($box);
		if($cn) {
			push @results, ['error_uid_exists_ldap', [uid => $box], [name => $name // $box], [ldap => $cn]];
			next;
		}

		$name //= canonical_name($box);
		my $uniq = $name;
		for(my $i = 2;; $i++) {
			$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?)');
			$q->execute($uniq);
			$res = $q->fetchall_arrayref;
			$q->finish;
			last unless @$res;
			$uniq = "$name #$i";
		}
		$name = $uniq;

		$q = $db->prepare_cached('INSERT INTO mailboxes (box, name, quota) VALUES (?, ?, ?)');
		$q->execute($box, $name, my $quota = $self->cfg->defaultquota);
		$q->finish;

		$q = $db->prepare_cached('INSERT INTO journal (subject, verb, object, value) VALUES (?, ?, ?, ?)');
		$q->execute($login, 'create box', $box, "name=$name");
		$q->finish;

		$journal .= "journal: $login created mailbox $box: name=$name\n";
		
		push @results, ['ok', [box => $box], [name => $name], [quota => $quota], [usage => 0]];
	}
	$db->commit;

	warn $journal if $journal;

	system($cfg->syncboxes);

	return \@results;
};

package UvT::Squarepeg::Ajax::Boxes::Create;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Boxes::Create::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

