# $Id: List.pm 33876 2011-02-14 14:06:57Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Users/List.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Users::List::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	$self->setDocumentElement($self->construct('ok', map {
		my ($uid, $name, $manager) = @$_;
		[user => [uid => $uid], [name => $name], [manager => $manager ? 'true' : 'false']]
	} @{$req->users}));
}

package UvT::Squarepeg::Ajax::Box::Users::List::Request;

use UvT::Squarepeg::Ajax::Box::Request -self;

field users => sub {
	my $self = shift;

	my $box = $self->box;

	die $self->errorpage('permission_denied')
		unless $self->has_access_to_box($box);

	my $db = $self->db;
	my $q = $db->prepare_cached('SELECT mailnames.uid, mailnames.name, maillinks.manager
		FROM mailnames JOIN maillinks USING (mailuser) JOIN mailboxes USING (mailbox)
		WHERE mailboxes.box = ? ORDER BY mailnames.uid');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	$db->commit;

	return $res;
};

package UvT::Squarepeg::Ajax::Box::Users::List;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Users::List::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Box::Users::List::Document(req => $req);
	return $doc->response;
}
