# $Id: Create.pm 34010 2011-02-22 16:31:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/lib/UvT/Squarepeg/Ajax/Box/Users/Create.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Squarepeg::Ajax::Box::Users::Create::Request;

use UvT::Squarepeg::Canonical;

use UvT::Squarepeg::Ajax::Box::Request -self;

param raw => sub {
	die shift->errorpage('missing_parameter', param => 'raw') unless $_;
};

field results => sub {
	my $self = shift;

	die $self->errorpage('bad_nonce')
		unless $self->nonce;

	my $box = $self->box;

	die $self->errorpage('permission_denied')
		unless $self->is_manager_for_box($box);

	my $db = $self->db;

	my $q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
	$q->execute($box);
	my $res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('box_does_not_exist', box => $box)
		unless @$res;

	my ($mailbox) = @{$res->[0]};

	$q = $db->prepare_cached('SELECT name FROM mailnames WHERE mailuser = ?');
	$q->execute($mailbox);
	$res = $q->fetchall_arrayref;
	$q->finish;

	die $self->errorpage('user_not_box', uid => $box, name => $res->[0][0])
		if @$res;

	my @users =
		grep { @$_ }
		map { s/\s+/ /g; [split(' ', $_, 2)] }
		split(/\n/, $self->raw);

	my @results;
	my $journal;

	foreach my $user (@users) {
		my ($uid, $name) = @$user;
		$uid = canonical_identifier($uid);
		$name = canonical_name($name);

		unless(defined $uid) {
			push @results, ['error_uid_invalid', [uid => $uid], [name => $name // $uid]];
			next;
		}

		my $q = $db->prepare_cached('SELECT mailuser, name FROM mailnames WHERE uid = ?');
		$q->execute($uid);
		my $res = $q->fetchall_arrayref;
		$q->finish;

		my $mailuser;
		if(@$res) {
			($mailuser, $name) = @{$res->[0]}
		} else {
			my $cn = $self->cfg->ldap->cn($uid);
			unless($cn) {
				push @results, ['error_uid_does_not_exist', [uid => $uid], [name => $name // $uid]];
				next;
			}

			$name //= $cn;
			my $uniq = $name;
			for(my $i = 2;; $i++) {
				$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE lower(name) = lower(?)');
				$q->execute($uniq);
				$res = $q->fetchall_arrayref;
				$q->finish;
				last unless @$res;
				$uniq = "$name #$i";
			}
			$name = $uniq;

			$q = $db->prepare_cached('INSERT INTO mailboxes (box, name, quota) VALUES (?, ?, ?)');
			$q->execute($uid, $name, $self->cfg->defaultquota);
			$q->finish;

			$q = $db->prepare_cached('SELECT mailbox FROM mailboxes WHERE box = ?');
			$q->execute($uid);
			my $res = $q->fetchall_arrayref;
			$q->finish;

			die "Can't find newly added user\n" unless @$res;

			($mailuser) = @{$res->[0]};

			$q = $db->prepare_cached('INSERT INTO mailusers (mailuser) VALUES (?)');
			$q->execute($mailuser);
			$q->finish;
		}

		$q = $db->prepare_cached('SELECT * FROM maillinks WHERE mailuser = ? AND mailbox = ? FOR UPDATE');
		$q->execute($mailuser, $mailbox);
		$res = $q->fetchall_arrayref;
		$q->finish;

		if(@$res) {
			push @results, ['error_link_exists', [uid => $uid], [name => $name]];
		} else {
			$q = $db->prepare_cached('INSERT INTO maillinks (mailuser, mailbox) VALUES (?, ?)');
			$q->execute($mailuser, $mailbox);
			$q->finish;
			push @results, ['ok', [uid => $uid], [name => $name]];
		}
	}
	$db->commit;

	system($self->cfg->syncboxes);

	return \@results;
};

package UvT::Squarepeg::Ajax::Box::Users::Create;

use UvT::Squarepeg::Handler -self;

sub handle {
	my $req = new UvT::Squarepeg::Ajax::Box::Users::Create::Request(cfg => $self, ctx => shift);
	my $doc = new UvT::Squarepeg::Ajax::Document(req => $req);
	return $doc->response;
}

