-- $Id: dovecot.sql 38166 2012-11-08 11:40:19Z wsl $
-- $URL: https://svn.uvt.nl/its-id/trunk/sources/squarepeg/doc/dovecot.sql $

-- Om te voorkomen dat dit per ongeluk gedraaid wordt:
\echo Niet zomaar draaien, dit gooit alle data weg!
\quit

\encoding UTF8

BEGIN;

DROP SCHEMA IF EXISTS dovecot CASCADE;
CREATE SCHEMA dovecot;

SET search_path TO dovecot;

CREATE SEQUENCE seq;

CREATE TABLE mailboxes (
	mailbox BIGINT
		NOT NULL
		DEFAULT nextval('seq')
		PRIMARY KEY,
	box TEXT
		UNIQUE
		NOT NULL,
	name TEXT
		UNIQUE
		CHECK (name <> ''),
	quota BIGINT
		NOT NULL
		DEFAULT 1
		CHECK (quota > 0)
);

CREATE TABLE mailusers (
	mailuser BIGINT
		NOT NULL
		REFERENCES mailboxes
			ON UPDATE CASCADE
			ON DELETE CASCADE
		PRIMARY KEY,
	admin BOOL
		NOT NULL
		DEFAULT FALSE
);

CREATE TABLE maillinks (
	mailuser BIGINT
		NOT NULL
		REFERENCES mailusers
			ON UPDATE CASCADE
			ON DELETE CASCADE,
	mailbox BIGINT
		NOT NULL
		REFERENCES mailboxes
			ON UPDATE CASCADE
			ON DELETE CASCADE,
	manager BOOL
		NOT NULL
		DEFAULT FALSE,
	PRIMARY KEY (mailuser, mailbox)
);

CREATE VIEW mailnames AS
	SELECT mailuser, box AS uid, name, admin
		FROM mailusers JOIN mailboxes ON mailusers.mailuser = mailboxes.mailbox;

CREATE TABLE journal (
	time TIMESTAMP WITH TIME ZONE
		NOT NULL
		DEFAULT CURRENT_TIMESTAMP,
	subject TEXT,
	verb TEXT
		NOT NULL,
	object TEXT,
	value TEXT
);

CREATE INDEX journal_time ON journal (time);
CLUSTER journal USING journal_time;

COMMIT;

REINDEX DATABASE dovecot;
VACUUM FULL ANALYZE;
