<?php 
require_once("$CFG->dirroot/mod/mediasite/edasclient.php");

define("MEDIASITE_EDAS_ENDPOINT", "/ExternalDataAccess_5_0/Service.asmx");

function mediasite_get_version () {
    global $CFG;

    $client = new ExternalAccessClient($CFG->mediasite_serverurl.MEDIASITE_EDAS_ENDPOINT);
    $client->Login($CFG->mediasite_username,$CFG->mediasite_password);
    $siteprops = $client->QuerySiteProperties();

    return $siteprops->Version;
}

function mediasite_search($searchtext, $resourcetype, $username)
{
    global $CFG;
    $client = new ExternalAccessClient($CFG->mediasite_serverurl.MEDIASITE_EDAS_ENDPOINT);
    $client->LoginWithImpersonation($CFG->mediasite_username,$CFG->mediasite_password, $username);
    
    if($resourcetype == 'Presentation') {		
        $presentationFilter = new PresentationFilter();
        $presentationFilter->PermissionMask = 'Execute';
        $presentationFilter->RootPermissionMask = 'Execute';
        $presentationFilter->FolderMask = 'Normal';
        $presentationFilter->StartDate = '1900-01-01';
        $presentationFilter->EndDate = '9999-12-31';
        $presentationFilter->SearchType = 'ExactPhrase';
        $presentationFilter->SortBy = 'Title';
        $presentationFilter->SortDirection = 'Ascending';
        $presentationFilter->SearchText = $searchtext;
        $presentationFilter->FieldsToSearch = 'Title';
        $results = $client->queryAllPresentations($presentationFilter);
        
        if(count($results) == 1) {
            $results = array($results);
        }
    }
    else if($resourcetype == 'Catalog') {	
        $catalogresults = $client->QueryCatalogShares(array('Execute'));
        $results = array();
        foreach($catalogresults as $catalogresult) {            
            if(strlen($searchtext) > 0 && stripos($catalogresult->Name, $searchtext) === false) {
                continue;
            }
            $results[count($results)] = $catalogresult;
        }
    }
    return $results;
}

function mediasite_check_resource_permission($resourceid, $resourcetype, $username) {
    global $CFG;
    
    $client = new ExternalAccessClient($CFG->mediasite_serverurl.MEDIASITE_EDAS_ENDPOINT);
    $client->LoginWithImpersonation($CFG->mediasite_username,$CFG->mediasite_password, $username);

    if($resourcetype == 'Presentation') {
        $resourceobj = new ResourceObjectRequest();
        $resourceobj->Id = $resourceid;
        $resourceobj->Type = 'Presentation';

        $response = $client->QueryResourcePermissions(array($resourceobj));

        if(sizeof($response) == 1) {
            $allowed = false;
            $permissions = explode(' ',$response->PermissionMask);
            
            foreach($permissions as $permission) {
                if($permission == 'DenyExecute') {
                    return false;
                }
                else if($permission == 'Execute') {
                    $allowed = true;
                }
            }
            return $allowed;
        }
    }
    else if($resourcetype == 'Catalog') {	
        $catalogshares = $client->QueryCatalogShares(array('Execute'));

        $resourceid = str_replace('-','',$resourceid);
        foreach($catalogshares as $catalogshare) {
            if($resourceid == str_replace('-','',$catalogshare->Id)) {
                return true;
            }
        }
    }
    return false;
}

function mediasite_get_playback_url($mediasitelink, $username) {    	

    global $CFG;

    $client = new ExternalAccessClient($CFG->mediasite_serverurl.MEDIASITE_EDAS_ENDPOINT);
    $client->Login($CFG->mediasite_username,$CFG->mediasite_password);
    
    $playbackbase;
    
    if($mediasitelink->resourcetype == 'Presentation') {
        $presentationdetails = $client->QueryPresentationDetails(array($mediasitelink->resourceid));
        $playbackbase = $presentationdetails->PlayerUrl;
    }
    else if($mediasitelink->resourcetype == 'Catalog') {
        $catalogshares = $client->QueryCatalogShares(array('Execute'));

        $resourceid = str_replace('-','',$mediasitelink->resourceid);
        foreach($catalogshares as $catalogshare) {
            if($resourceid == str_replace('-','',$catalogshare->Id)) {
                $playbackbase = $catalogshare->CatalogUrl;
            }
        }
    }
    
    if(!isset($playbackbase)) {
        print_error( get_string('mediasitenotfound', 'mediasite'));
        exit;
    }    

    $clientip = null;
    if($CFG->mediasite_restricttoip == '1') {
        $clientip = $_SERVER['REMOTE_ADDR'];
    }
    
    $authticket = $client->CreateAuthTicket($username, $mediasitelink->resourceid, $clientip, $CFG->mediasite_ticketduration);
        
    if( strpos($playbackbase, '?') !== false){
    	$playbackurl = "$playbackbase&authTicket=$authticket";
    } 
    else{
    	$playbackurl = "$playbackbase?authTicket=$authticket";
    }
	
    return $playbackurl;
}

?>
