<?php
// This file is part of Ephorus
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

function xmldb_plagiarism_ephorus_upgrade($oldversion = 0) {
    global $DB;
    $dbman = $DB->get_manager();

    $result = true;

    if ($result && $oldversion < 2012073124) {
        /* Rename the table fields to a better size (< 30) */
        $document = new xmldb_table('ephorus_document');
        $duplicateguid = new xmldb_field('duplicate_original_guid', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $duplicateguid)) {
            $dbman->rename_field($document, $duplicateguid, 'duplicate_guid');
        }
        $duplicatename = new xmldb_field('duplicate_original_studentname', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $duplicatename)) {
            $dbman->rename_field($document, $duplicatename, 'duplicate_studentname');
        }
        $duplicatenumber = new xmldb_field('duplicate_original_studentnumber', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $duplicatenumber)) {
            $dbman->rename_field($document, $duplicatenumber, 'duplicate_studentnumber');
        }

        set_config('ephorus_usecron', 1, 'plagiarism');
        set_config('ephorus_logging', 1, 'plagiarism');
    }
    if ($result && $oldversion < 2013041024) {
        $document = new xmldb_table('ephorus_document');
        $duplicatename = new xmldb_field('duplicate_studentname', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $duplicatename)) {
            $dbman->rename_field($document, $duplicatename, 'duplicate_student_name');
        }
        $duplicatenumber = new xmldb_field('duplicate_studentnumber', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $duplicatenumber)) {
            $dbman->rename_field($document, $duplicatenumber, 'duplicate_student_number');
        }
        $status_desc = new xmldb_field('status_description', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $status_desc)) {
            $dbman->rename_field($document, $status_desc, 'error');
        }

        $res_table = new xmldb_table('ephorus_result');
        $diff = new xmldb_field('diff', XMLDB_TYPE_TEXT, 'long');
        if ($dbman->field_exists($res_table, $diff)) {
            $dbman->rename_field($res_table, $diff, 'comparison');
        }

        $DB->set_field('ephorus_document', 'status', 99, array('status' => 7));
    }
    if ($result && $oldversion < 2013052224) {
        $document = new xmldb_table('ephorus_document');
        $date = new xmldb_field('date', XMLDB_TYPE_CHAR);
        if ($dbman->field_exists($document, $date)) {
            $dbman->rename_field($document, $date, 'date_created');
        }

        if($ephorus_id = $DB->get_field('tool_customlang_components', 'id', array('name' => 'plagiarism_ephorus'))) {
            $DB->delete_records('tool_customlang', array('componentid' => $ephorus_id));
        }
    }
    if ($result && $oldversion < 2013080524) {
        set_config('use_cron', get_config('plagiarism')->ephorus_usecron, 'plagiarism_ephorus');
        unset_config('ephorus_usecron', 'plagiarism');
        
        set_config('logging', get_config('plagiarism')->ephorus_logging, 'plagiarism_ephorus');
        unset_config('ephorus_logging', 'plagiarism');
        
        set_config('handin_code', get_config('plagiarism')->ephorus_handincode, 'plagiarism_ephorus');
        unset_config('ephorus_handincode', 'plagiarism');
        
        set_config('handin_address', get_config('plagiarism')->ephorus_handinaddress, 'plagiarism_ephorus');
        unset_config('ephorus_handinaddress', 'plagiarism');
        
        set_config('index_address', get_config('plagiarism')->ephorus_indexaddress, 'plagiarism_ephorus');
        unset_config('ephorus_indexaddress', 'plagiarism');
        
        set_config('processtype', get_config('plagiarism')->ephorus_processtype, 'plagiarism_ephorus');
        unset_config('ephorus_processtype', 'plagiarism');
        
        set_config('student_disclosure', get_config('plagiarism')->ephorus_studentdisclosure, 'plagiarism_ephorus');
        unset_config('ephorus_studentdisclosure', 'plagiarism');
    }
    return $result;
}