#!/usr/bin/python
'''
Copyright 2014 Cisco Systems, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

'''
# Script to initialize the autodiscovery process 
# and to orchestrate the workflow for the same

from UcsNagiosDiscovery import UcsNagiosDiscovery, encode
from base64 import b64encode
import sys
import shlex
import shutil
import os
from optparse import OptionParser
from UcsNagiosFileHandler import get_ucs_details_from_csv
import subprocess
import re
import itertools
from PropertyHandler import PropertyHandlerClass
python_latest = True
try:
    from shutil import ignore_patterns
except ImportError:
    python_latest = False
import shutil
import stat

#Auto Discovery version
UCSM_AD_VERSION = "0.9.4"

# CSV Rows
class CsvRows:
    USERNAME = 0
    PASSWORD = 1
    PORT = 2
    NOSSL = 3
    PROXY = 4

def copytree(src, dst, symlinks = False, ignore = None):
  if not os.path.exists(dst):
    os.makedirs(dst)
    shutil.copystat(src, dst)
  lst = os.listdir(src)
  if ignore:
    excl = ignore(src, lst)
    lst = [x for x in lst if x not in excl]
  for item in lst:
    s = os.path.join(src, item)
    d = os.path.join(dst, item)
    if symlinks and os.path.islink(s):
      if os.path.lexists(d):
        os.remove(d)
      os.symlink(os.readlink(s), d)
      try:
        st = os.lstat(s)
        mode = stat.S_IMODE(st.st_mode)
        os.lchmod(d, mode)
      except:
        pass # lchmod not available
    elif os.path.isdir(s):
      copytree(s, d, symlinks, ignore)
    else:
      shutil.copy2(s, d)

def execute_unix_cmd(command):
    ''' Helper function for executing Unix commands'''
    cmd_args = shlex.split(command.strip('"'))
    process_obj = subprocess.Popen(cmd_args,
                         stdout=subprocess.PIPE,
                         stderr=subprocess.PIPE)
    cmd_out = process_obj.communicate()
    cmd_return_code = process_obj.wait()

    return (cmd_return_code, cmd_out)

def restart_nagios(restart_command):
    '''Function for resatring the Nagios service'''
    print "Restarting the Nagios Service ..."
    return_value = execute_unix_cmd(restart_command)[0]
    if return_value != 0:
        print "Failed to restart the Nagios service.\nPlease try restarting manually."
    else:
        print "Successfully restarted the Nagios service."
    return return_value

def check_file(file_path):
    ''' Function to check file status before we proceed any further
    with the workflow'''
    if os.path.exists(file_path) == True:
        print file_path, "File exists"
    else:
        raise Exception("ERROR : The required file does not exists on the specified path %s" % file_path)
    try:
        fileType = execute_unix_cmd("file " + file_path)
        if (fileType[0] == 0 and re.search("ASCII", fileType[1][0]) != None):
            pass
        else:
            raise Exception("Error occurred while checking the file format.File may contain invalid characters.")
    except Exception, err:
        raise Exception(str(err))

def verify_ip_or_host(ip):
    try:
       #for num in ip.rstrip().split('.'):
       #    print num
       #    if not (0<= int(num.split('-')[0])<256):
       #        return False
       if ip.count('.') == 3:
           return True
    except:
       return False       


def create_ip_range(ucs_dict):
    try:
        octets = ucs_ip.split('.')
        chunks = [map(int, octet.split('-')) for octet in octets]
        ranges = [range(c[0], c[1] + 1) if len(c) == 2 else c for c in chunks]
        for address in itertools.product(*ranges):
            yield '.'.join(map(str, address))
    except:
        pass

if __name__ == '__main__':
    # Main
    # Variables
    UCS_NAGIOS_AUTO_DISCOVERY = os.path.dirname(os.path.realpath(__file__))
    NAGIOS_CFG_FILE = 'NagiosAutoDiscoveryUCS.cfg'
    UCS_HOST_FILE = 'UCSHostInfo.csv'
    CISCO_FOLDER = 'cisco'
    CISCO_NAGIOS_OBJECT_DIR = 'ucsObjs'
    PAYLOAD_DIR = 'payload'
    LOGO_DIR = 'logos'
    # Create default file path for usc host csv
    host_csv_file = os.path.join(UCS_NAGIOS_AUTO_DISCOVERY, UCS_HOST_FILE)
    retval = 1
    parser = OptionParser()
    parser.add_option("-f", "--hostCsvFile", dest="ucs_csv_file",
                      default=host_csv_file, type="str",
                      help="Provide the input csv file with ucs details.")
    parser.add_option("-H", "--Host", dest="host_name",
                      default="", type="str",
                      help="Specifies the IP address or the DNS name of the UCS server to which user want to connect.")
    parser.add_option("-u", "--user", dest="user", default="",
                      help="Specify UCS Login user name")
    parser.add_option("-p", "--password", dest="password", default="",
                      help="Specify UCS user password")
    parser.add_option("-n", "--port", dest="port", default=None,
                      help="Specify the UCS Manager port.")
    parser.add_option("--NoSsl", action="store_true", dest="no_ssl", default=False,
                      help="If this flag is specified then the connection is made without using SSL protocol")
    parser.add_option("-r", "--restartService", dest="restart_service",
                      default=False, action="store_true",
                      help="If the value is set to True the Nagios service will be restarted.Default is False")
    parser.add_option("--proxy", dest="global_proxy",
                      default=None, type="str",
                      help="Proxy URL for connecting UCS")
    parser.add_option("--debug", action="store_true", dest="debug", default=False,
                      help='If this flag is specified it will print the appropriate debug information')
    parser.add_option("--version", action="store_true",
                      dest="version", default=False,
                      help='If specified it will print the current Cisco UCSM Auto Discovery version.'
                      'NOTE: All the other options will be ignored.')
    parser.add_option("-D","--disable-hostgroup-creation", dest="host_group_disabled",
                      default=False, action="store_true",
                      help="Provide an option to disable default host group creation via auto-discovery.")
    parser.add_option("-S","--singleHost", dest="single_host",
                      default=False, action="store_true",
                      help="Provide an option to disable default host creation and just create one host i.e Domain.")
    (options, cmd_args) = parser.parse_args()
    # Print Plugin Version
    if options.version:
        print "Cisco UCSM Nagios Auto Discovery version : ", UCSM_AD_VERSION
        sys.exit(0)
        
    host_csv_file = options.ucs_csv_file.strip()
    if host_csv_file.strip() == "":
        print "Provide the correct path to CSV file"
        sys.exit(retval)
    restart_service = options.restart_service
    global_proxy = options.global_proxy
    debug=options.debug
    single_host= options.single_host
    disable_host_group = options.host_group_disabled
    ucs_info_dict = dict()

    if options.host_name.strip() !="":
        print "Using CLI parameters for UCS Host details....\n"
        if options.user.strip() == "":
            parser.error("Provide user name for the given ucshost")
        elif options.password.strip()== "":
            parser.error("Provide ucs password for the given ucshost")
        else:
           if options.port is None:
               if options.no_ssl:
                   port = 80
               else:
                   port = 443
           else:
               port = int(options.port)
        val = [options.user.strip(),options.password.strip(),str(port),str(options.no_ssl)]
        ucs_info_dict.update({options.host_name.strip():val})
    else:
        print 'UCS host information csv file  ', host_csv_file
        try:
            ucs_info_dict = get_ucs_details_from_csv(host_csv_file)
        except Exception, csv_error:
            print "Error occurred while trying to parse the host information file '", host_csv_file, "'"
            print "Exception >> ' ", str(csv_error), "'"
            print "Exiting Auto Discovery process without any modifications."
            sys.exit(retval)

    try:
        new_ucs_dict = {}
        for ucs_ip in ucs_info_dict.keys():
            if verify_ip_or_host(ucs_ip):
                ucs_info_dict1 = create_ip_range(ucs_ip)
                for ele in ucs_info_dict1:
                    octets = ele.split('.')
                    try:
                        if (int(octets[0])== 0 ) or (int(octets[0]) > 255) or (int(octets[1]) > 255) or \
                             (int(octets[2])>255) or (int(octets[3]) > 255):
                            continue
                        else:
                            new_ucs_dict[ele] = ucs_info_dict[ucs_ip]
                    except:
                        continue
            else:
                new_ucs_dict[ucs_ip] = ucs_info_dict[ucs_ip]
        ucs_info_dict = new_ucs_dict
        if not ucs_info_dict:
            print "Error occurred while trying to parse the host information"
            print "Exiting Auto Discovery process without any modifications."
            sys.exit(retval)
    except Exception:
        print "Exiting Auto Discovery process without any modifications."
        sys.exit(retval)

    # Create a property Object and parse the property file
    NAGIOS_CONFIGURATION_FILE = os.path.join(UCS_NAGIOS_AUTO_DISCOVERY, NAGIOS_CFG_FILE)
    try:
        check_file(NAGIOS_CONFIGURATION_FILE)
    except Exception, err:
        print "Error occurred while trying to parse the auto discovery file '", NAGIOS_CONFIGURATION_FILE, "'"
        print "Exception >> '", str(err), "'"
        print "Exiting Auto Discovery process without any modifications."
        sys.exit(retval)
    property_object = PropertyHandlerClass()
    try:
        plugin_cfg_dict = property_object.read_properties(NAGIOS_CONFIGURATION_FILE)
    except Exception, err:
        print "Error while trying to read nagios  configuration file '%s' ." % NAGIOS_CONFIGURATION_FILE
        print "Exception >> '", str(err), "'"
        print "Exiting Auto Discovery process without any modifications."
        sys.exit(retval)

    try:
        remove_flag = plugin_cfg_dict['REMOVE_OLD_DISCOVERY'] 
    except:
        remove_flag = "true"
    ucs_cfg_obj_folder = os.path.join(plugin_cfg_dict['NAGIOS_HOME'], CISCO_FOLDER, CISCO_NAGIOS_OBJECT_DIR)
    ## Remove existing UCS cfg's
    if remove_flag.strip().lower() != "false": 
        if os.path.exists(ucs_cfg_obj_folder):
            print "Removing the folder path : " + ucs_cfg_obj_folder
            shutil.rmtree(ucs_cfg_obj_folder)

    ## Copying payload to the related folders
    # check if path exists or not
    cisco_folder = os.path.join(plugin_cfg_dict['NAGIOS_HOME'], CISCO_FOLDER)
    if not os.path.exists(cisco_folder):
        os.makedirs(cisco_folder)

    source = os.path.join(UCS_NAGIOS_AUTO_DISCOVERY, PAYLOAD_DIR)
    print "Copying the payload to " + ucs_cfg_obj_folder
    if python_latest:
        copytree(source, ucs_cfg_obj_folder, ignore=ignore_patterns('logos*'))
    else:
        copytree(source, ucs_cfg_obj_folder)
        logos_path_to_remove = os.path.join(plugin_cfg_dict['NAGIOS_HOME'], CISCO_FOLDER, CISCO_NAGIOS_OBJECT_DIR, LOGO_DIR)
        shutil.rmtree(logos_path_to_remove)

    ucs_obj_valid = False
    for ucs_ip in ucs_info_dict.keys():
        # Initialize the variables
        user = ""
        password = ""
        port = None
        no_ssl = False
        try:
            proxy = ucs_info_dict[ucs_ip][CsvRows.PROXY].strip()
            if proxy == "":
                raise IndexError
        except IndexError:
            if global_proxy != None and global_proxy.strip() != "":
                proxy = global_proxy
            else:
                proxy = None
        try:
            user = ucs_info_dict[ucs_ip][CsvRows.USERNAME].strip()
            password = b64encode(ucs_info_dict[ucs_ip][CsvRows.PASSWORD].strip())
            if user == "" or password == "":
                raise Exception
        except:
            print ("Check if username and password are provided for UCS '%s' . " % ucs_ip)
            continue
        try:
            port = ucs_info_dict[ucs_ip][CsvRows.PORT].strip()
            if port == "":
                raise IndexError
            if (int(port) < 1) or (int(port) > 65535):
                raise Exception
        except IndexError:
            port = '443'
        except Exception:
            print ("Invalid Input Port '%s' .Check and provide a valid port number for UCS Host '%s'." % (port, ucs_ip))
            continue
        try:
            no_ssl = ucs_info_dict[ucs_ip][CsvRows.NOSSL].strip()
            if no_ssl.lower() == 'false' or no_ssl == "":
                no_ssl = False
            else:
                no_ssl = True
        except IndexError:
            no_ssl = False

        print '-' * 60
        print ("Connecting to UCS - '%s' with user '%s' and password '%s' " % (ucs_ip, user, password))
        print"Connect using NoSsl as '%s', port as '%s' and  proxy as '%s' " % (no_ssl, port, proxy)
        # Check for exceptions and in case of error
        # print error and continue the discovery process

        try:
            ucs_object = UcsNagiosDiscovery(ucs_ip, user, password, plugin_cfg_dict, no_ssl, port, proxy,debug)
            ucs_object.create_base_host_file()
            ucs_object.discover_ucs(single_host)
            ucs_object.create_host_ext_info_xml_file(ucs_ip)
            ucs_object.create_host_file(single_host)
            if disable_host_group != True:
                ucs_object.create_host_group_xml_file(ucs_ip)
            else:
                ucs_object.update_host_group_xml_file(ucs_ip,disable_host_group)
            if single_host:
                ucs_object.update_host_group_xml_file(ucs_ip)
                ucs_object.update_host_ext_xml_file(ucs_ip)

            ucs_object.create_service_xml_file(single_host)
            ucs_object.convert_service_xml_to_nagios_file()
            if remove_flag.strip().lower() == "false":
                ucs_object.remove_non_required_host_files()
            ucs_object.close_ucs_handle()
            ucsm_ip = None
            ucs_obj_valid = True
        except Exception, err:
            print ("Error while trying to discover :  " + ucs_ip)
            print "Error is of Type :  ", err.__class__.__name__, " Message >>", str(err)
            if debug:
                  import traceback, sys
                  print '-'*60
                  traceback.print_exc(file=sys.stdout)
                  print '-'*60

            continue
        # For Loop Ends here
        print '=' * 60
    if ucs_obj_valid != False:
        ucs_object.convert_host_group_xml_to_nagios_file()
        ucs_object.convert_host_ext_info_xml_to_nagios_file()
    else:
        print "Error while trying to auto discover UCS Infrastructure. Check if any of the UCS are reachable. "
        sys.exit(retval)

    print "Finished with the Auto Discovery Process."
    retval = 0
    try :
        if restart_service == True:
            retval = restart_nagios(plugin_cfg_dict['NAGIOS_RESTART_CMD'])
        else:
            var = raw_input("Do you want to restart the Nagios service now (y/n) : ")
            answer = var.strip().lower()
            if answer == "yes" or answer == "y":
                # restart nagios
                retval = restart_nagios(plugin_cfg_dict['NAGIOS_RESTART_CMD'])
            else:
                print "Restart the Nagios service manually."
    except Exception,run_error:
        print "Error while trying to restart the Nagios process using the following cmd : \n", plugin_cfg_dict['NAGIOS_RESTART_CMD']
        print "Error is of Type :  ", run_error.__class__.__name__, " Message >>", str(run_error)
        if debug:
            import traceback, sys
            print '-'*60
            traceback.print_exc(file=sys.stdout)
            print '-'*60
            from UcsSdk import Version
            print '-' * 20, "Additional information", '-' * 20
            print "Python version : ", sys.version
            print "Python UCSM SDK version : " , Version.__version__
            print "Cisco UCSM Nagios Monitoring Plugin version : ", UCSM_AD_VERSION
        print "Check and restart the Nagios service manually."
        retval = 1
    
    sys.exit(retval)
