<?php
// $Id$

/**
 * MediaMosa is Open Source Software to build a Full Featured, Webservice
 * Oriented Media Management and Distribution platform (http://mediamosa.org)
 *
 * Copyright (C) 2012 SURFnet BV (http://www.surfnet.nl) and Kennisnet
 * (http://www.kennisnet.nl)
 *
 * MediaMosa is based on the open source Drupal platform and
 * was originally developed by Madcap BV (http://www.madcap.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, you can find it at:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

 /**
  * @file
  * Debug class.
  */
class mediamosa_debug {

  /**
   * Default debug logger, logs only in debug mode (level 5, normal).
   *
   * @param string $message
   * @param array $variables
   * @param string $type
   */
  public static function log($message, array $variables = array(), $type = 'debug', $link = NULL) {
    if (self::is_debug_normal()) {
      mediamosa_watchdog::log($message, $variables, WATCHDOG_DEBUG, $type, $link);
    }
  }

  /**
   * Log all types.
   *
   * @param miced $data
   * @param string $severity
   * @param string $type
   */
  public static function log_export($data, $severity = WATCHDOG_NOTICE, $type = NULL) {
    if (self::is_debug_normal()) {
      mediamosa_watchdog::log(highlight_string(var_export($data, TRUE), TRUE), array(), $severity, $type);
    }
  }

  /**
   * Log asset ids.
   */
  public static function log_asset($asset_id, $message, array $variables = array(), $type = NULL) {
    if (self::is_debug_normal()) {
      mediamosa_watchdog::log_asset($asset_id, $message, $variables, WATCHDOG_DEBUG, $type);
    }
  }

  /**
   * Log mediafile ids.
   */
  public static function log_mediafile($mediafile_id, $message, array $variables = array(), $asset_id = NULL, $type = NULL) {
    if (self::is_debug_normal()) {
      mediamosa_watchdog::log_mediafile($mediafile_id, $message, $variables, $asset_id, WATCHDOG_DEBUG, $type);
    }
  }

  /**
   * High debug logger, logs only in high debug mode (level 10, high).
   *
   * @param string $message
   * @param array $variables
   * @param string $type
   */
  public static function log_high($message, array $variables = array(), $type = NULL) {
    if (self::is_debug_high()) {
      mediamosa_watchdog::log($message, $variables, WATCHDOG_DEBUG, $type);
    }
  }

  /**
   * High debug logger, log asset ids.
   */
  public static function log_high_asset($asset_id, $message, array $variables = array(), $type = NULL) {
    if (self::is_debug_high()) {
      mediamosa_watchdog::log_asset($asset_id, $message, $variables, WATCHDOG_DEBUG, $type);
    }
  }

  /**
   * High debug logger, log mediafile ids.
   */
  public static function log_high_mediafile($mediafile_id, $message, array $variables = array(), $asset_id, $type = NULL) {
    if (self::is_debug_high()) {
      mediamosa_watchdog::log_mediafile($mediafile_id, $message, $variables, $asset_id, WATCHDOG_DEBUG, $type);
    }
  }

  /**
   * Log without logging to the database, go to php.log instead.
   */
  public static function error_log($message, $file = NULL, $line = NULL) {

    if (empty($file)) {
      $caller = _drupal_get_last_caller(debug_backtrace());
      $file = $caller['file'];
      $line = $caller['line'];
    }

    error_log(strtr('MediaMosa debug: @message in @file on line @line', array('@file' => (!empty($file) ? $file : 'unknown'), '@line' => (isset($line) ? $line : 'unknown'), '@message' => drupal_ucfirst($message))));
  }

  /**
   * Returns TRUE / FALSE to indicate debug mode ON / OFF.
   */
  public static function is_debug() {
    return (variable_get('mediamosa_debug_level', 0) > 0);
  }

  /**
   * Returns TRUE / FALSE to indicate normal debug.
   */
  public static function is_debug_normal() {
    return (variable_get('mediamosa_debug_level', 0) >= 5);
  }

  /**
   * Returns TRUE / FALSE to indicate debug mode for logging.
   */
  public static function is_debug_high() {
    return (variable_get('mediamosa_debug_level', 0) >= 10);
  }

  /**
   * Log the query string for a db_query result object..
   */
  public static function log_query_string($query_object) {
    mediamosa_watchdog::log($query_object->queryString, array(), WATCHDOG_INFO, 'DB query');
  }
}
