<?php
// $Id$

/**
 * MediaMosa is Open Source Software to build a Full Featured, Webservice
 * Oriented Media Management and Distribution platform (http://mediamosa.org)
 *
 * Copyright (C) 2012 SURFnet BV (http://www.surfnet.nl) and Kennisnet
 * (http://www.kennisnet.nl)
 *
 * MediaMosa is based on the open source Drupal platform and
 * was originally developed by Madcap BV (http://www.madcap.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, you can find it at:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

/**
 * sites/all/modules/mediamosa/core/app/authentication/3rdparty/OAuth.php:
 *
 * The MIT License
 *
 * Copyright (c) 2007 Andy Smith
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
  * @file
  * The REST calls of the Application Authentication.
  */

/*
 * URI: /openapi/oauth/request_token
 * Method: GET
 */
class mediamosa_rest_call_oauth_request_token extends mediamosa_rest_call {
  // ------------------------------------------------------------------ Consts.
  // Rest vars;
  const OAUTH_CONSUMER_KEY = 'oauth_consumer_key';
  const OAUTH_SIGNATURE_METHOD = 'oauth_signature_method';
  const OAUTH_SIGNATURE_METHOD_HMAC_SHA1 = 'HMAC-SHA1';
  const OAUTH_SIGNATURE_METHOD_PLAINTEXT = 'PLAINTEXT';
  const OAUTH_SIGNATURE_METHOD_RSA_SHA1 = 'RSA-SHA1';
  const OAUTH_TIMESTAMP = 'oauth_timestamp';
  const OAUTH_NONCE = 'oauth_nonce';
  const OAUTH_CALLBACK = 'oauth_callback';
  const OAUTH_SIGNATURE = 'oauth_signature';
  const OAUTH_VERSION = 'oauth_version';
  const OAUTH_VERSION_10 = '1.0';

  // ------------------------------------------------------------------ Functions (public).
  public function get_var_setup() {
    $var_setup = array(
      self::VARS => array(
        self::OAUTH_CONSUMER_KEY => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_ALPHA_NUM,
          self::VAR_DESCRIPTION => 'The identifier portion of the client credentials (equivalent to a username).',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_SIGNATURE_METHOD => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_SIGNATURE_METHOD,
          self::VAR_DESCRIPTION => 'The name of the signature method used by the client to sign the request.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
          self::VAR_ALLOWED_VALUES => array(
            self::OAUTH_SIGNATURE_METHOD_HMAC_SHA1,
            self::OAUTH_SIGNATURE_METHOD_PLAINTEXT,
            // TODO: implement RSA?
            //self::OAUTH_SIGNATURE_METHOD_RSA_SHA1,
          ),
          //self::VAR_DEFAULT_VALUE => self::OAUTH_SIGNATURE_METHOD_HMAC_SHA1,
        ),
        self::OAUTH_TIMESTAMP => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_INT,
          self::VAR_DESCRIPTION => 'The timestamp.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
          self::VAR_RANGE_START => 0,
        ),
        self::OAUTH_NONCE => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_ALPHA_NUM,
          self::VAR_DESCRIPTION => 'A nonce is a random string, uniquely generated by the client to allow the server to verify that a request has never been made before and helps prevent replay attacks when requests are made over a non-secure channel.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_CALLBACK => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_URL,
          self::VAR_DESCRIPTION => 'An absolute URI back to which the server will redirect the resource owner when the Resource Owner Authorization step is completed.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_SIGNATURE => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_SIGNATURE,
          self::VAR_DESCRIPTION => 'A password portion of the client credentials encoded by the given signature method.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_VERSION => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_VERSION,
          self::VAR_DESCRIPTION => 'Provides the version of the authentication process.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_NO,
          self::VAR_ALLOWED_VALUES => array(
            self::OAUTH_VERSION_10,
          ),
          self::VAR_DEFAULT_VALUE => self::OAUTH_VERSION_10,
        ),
      )
    );

    // Enrich with required REST vars.
    return self::get_var_setup_default($var_setup, FALSE);
  }

  // ------------------------------------------------------------------ Do Call.
  public function do_call() {
    $mediamosa = mediamosa::get();

    // Get params.
    $oauth_consumer_key = $this->get_param_value(self::OAUTH_CONSUMER_KEY);
    $oauth_signature_method = $this->get_param_value(self::OAUTH_SIGNATURE_METHOD);
    $oauth_timestamp = $this->get_param_value(self::OAUTH_TIMESTAMP);
    $oauth_nonce = $this->get_param_value(self::OAUTH_NONCE);
    $oauth_callback = $this->get_param_value(self::OAUTH_CALLBACK);
    $oauth_signature = $this->get_param_value(self::OAUTH_SIGNATURE);
    $oauth_version = $this->get_param_value(self::OAUTH_VERSION);

    $oauth_server = mediamosa_app_oauth::create_server();

    $req = OAuthRequest::from_request();
    $token = $oauth_server->fetch_request_token($req);
    $token .= '&oauth_callback_confirmed=true';

    $mediamosa->add_item($token);
  }
}

/*
 * URI: /openapi/oauth/access_token
 * Method: GET
 */
class mediamosa_rest_call_oauth_access_token extends mediamosa_rest_call {
  // ------------------------------------------------------------------ Consts.
  // Rest vars;
  const OAUTH_CONSUMER_KEY = 'oauth_consumer_key';
  const OAUTH_SIGNATURE_METHOD = 'oauth_signature_method';
  const OAUTH_SIGNATURE_METHOD_HMAC_SHA1 = 'HMAC-SHA1';
  const OAUTH_SIGNATURE_METHOD_PLAINTEXT = 'PLAINTEXT';
  const OAUTH_SIGNATURE_METHOD_RSA_SHA1 = 'RSA-SHA1';
  const OAUTH_TIMESTAMP = 'oauth_timestamp';
  const OAUTH_NONCE = 'oauth_nonce';
  const OAUTH_SIGNATURE = 'oauth_signature';
  const OAUTH_VERSION = 'oauth_version';
  const OAUTH_VERSION_10 = '1.0';
  const OAUTH_TOKEN = 'oauth_token';
  const OAUTH_VERIFIER = 'oauth_verifier';
  // TODO: Do we implement "oauth_session_handle"?
  // The Yahoo doc uses this parameter, but not others.
  // http://developer.yahoo.com/oauth/guide/oauth-auth-flow.html

  // ------------------------------------------------------------------ Functions (public).
  public function get_var_setup() {
    $var_setup = array(
      self::VARS => array(
        self::OAUTH_CONSUMER_KEY => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_ALPHA_NUM,
          self::VAR_DESCRIPTION => 'The identifier portion of the client credentials (equivalent to a username).',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_SIGNATURE_METHOD => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_SIGNATURE_METHOD,
          self::VAR_DESCRIPTION => 'The name of the signature method used by the client to sign the request.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
          self::VAR_ALLOWED_VALUES => array(
            self::OAUTH_SIGNATURE_METHOD_HMAC_SHA1,
            self::OAUTH_SIGNATURE_METHOD_PLAINTEXT,
            // TODO: implement RSA?
            //self::OAUTH_SIGNATURE_METHOD_RSA_SHA1,
          ),
          //self::VAR_DEFAULT_VALUE => self::OAUTH_SIGNATURE_METHOD_HMAC_SHA1,
        ),
        self::OAUTH_TIMESTAMP => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_INT,
          self::VAR_DESCRIPTION => 'The timestamp.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
          self::VAR_RANGE_START => 0,
        ),
        self::OAUTH_NONCE => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_ALPHA_NUM,
          self::VAR_DESCRIPTION => 'A nonce is a random string, uniquely generated by the client to allow the server to verify that a request has never been made before and helps prevent replay attacks when requests are made over a non-secure channel.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_SIGNATURE => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_SIGNATURE,
          self::VAR_DESCRIPTION => 'A password portion of the client credentials encoded by the given signature method.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_VERSION => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_VERSION,
          self::VAR_DESCRIPTION => 'Provides the version of the authentication process.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_NO,
          self::VAR_ALLOWED_VALUES => array(
            self::OAUTH_VERSION_10,
          ),
          self::VAR_DEFAULT_VALUE => self::OAUTH_VERSION_10,
        ),
        self::OAUTH_TOKEN => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_TOKEN,
          self::VAR_DESCRIPTION => 'The token identifier.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_YES,
        ),
        self::OAUTH_VERIFIER => array(
          self::VAR_TYPE => mediamosa_sdk::TYPE_OAUTH_VERIFIER,
          self::VAR_DESCRIPTION => 'The verification code.',
          self::VAR_IS_REQUIRED => self::VAR_IS_REQUIRED_NO,
        ),
      )
    );

    // Enrich with required REST vars.
    return self::get_var_setup_default($var_setup, FALSE);
  }

  // ------------------------------------------------------------------ Do Call.
  public function do_call() {
    $mediamosa = mediamosa::get();

    // Get params.
    $oauth_consumer_key = $this->get_param_value(self::OAUTH_CONSUMER_KEY);
    $oauth_signature_method = $this->get_param_value(self::OAUTH_SIGNATURE_METHOD);
    $oauth_timestamp = $this->get_param_value(self::OAUTH_TIMESTAMP);
    $oauth_nonce = $this->get_param_value(self::OAUTH_NONCE);
    $oauth_signature = $this->get_param_value(self::OAUTH_SIGNATURE);
    $oauth_version = $this->get_param_value(self::OAUTH_VERSION);
    $oauth_token = $this->get_param_value(self::OAUTH_TOKEN);
    $oauth_verifier = $this->get_param_value(self::OAUTH_VERIFIER);

    $oauth_server = mediamosa_app_oauth::create_server();

    $req = OAuthRequest::from_request();
    $token = $oauth_server->fetch_access_token($req);

    $mediamosa->add_item($token);
  }
}
