<?php
/**
 * @file
 * Admin functions.
 */

/**
 * Configuration form(s) for UvT.
 *
 * @return array
 *   An array representing the form definition.
 */
function _mediamosa_sb_uvt_retention_form() {

  $form = array();

  $form['mediamosa_sb_uvt_retention_cron_mail'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable nightly cron to check retentions and send mail.'),
    '#default_value' => variable_get('mediamosa_sb_uvt_retention_cron_mail', FALSE),
  );
  $form['mediamosa_sb_uvt_retention_cron_delete'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable nightly cron to delete retention assets.'),
    '#default_value' => variable_get('mediamosa_sb_uvt_retention_cron_delete', FALSE),
  );
  $form['mediamosa_sb_uvt_retention_days'] = array(
    '#type' => 'textfield',
    '#title' => t('Number of days after which assets will be deleted. This starts after the mail is sent.'),
    '#default_value' => variable_get('mediamosa_sb_uvt_retention_days', 30),
  );
  $form['mediamosa_sb_uvt_cron_limit_number'] = array(
    '#type' => 'textfield',
    '#title' => t('limit the number of assets that will be deleted/mails that will be sent during a cron run.'),
    '#default_value' => variable_get('mediamosa_sb_uvt_cron_limit_number', 5),
  );

  $now = date('Y-m-d');
  $numdays = variable_get('mediamosa_sb_uvt_retention_days', 30);
  $days_ago = date('Y-m-d', strtotime(strtr('-@numdays days', array('@numdays' => $numdays))));

  // Determine how many mails will be sent.
  $options = array(
    'offset' => 0,
    'limit' => 5,
    'is_app_admin' => TRUE,
    'calculate_total_count' => 'TRUE',
    'hide_empty_assets' => 'FALSE',
    'published' => 'ALL',
  );
  $options['cql'] = strtr("(retention_date < '@now') and retention_date_mail = NULL",
                    array(
                      '@now' => $now,
                    )
  );
  $sent_mail = MediaMosaCkConnectorWrapper::search_asset($options);
  $form['retention_to_sent'] = array('#markup' => '<div>Number of mails that will be sent next cron: ' . $sent_mail->xml->header->item_count_total . '</div>');

  // Determine how many assets have status wait for action after mail.
  $options['cql'] = strtr("retention_date < '@now' and retention_date_mail <> NULL",
                    array(
                      '@now' => $now,
                      '@days_ago' => $days_ago,
                    )
  );
  $results = MediaMosaCkConnectorWrapper::search_asset($options);
  $form['retention_wait'] = array('#markup' => '<div>' . 'Number of rentention assets that wait for mail action: ' . $results->xml->header->item_count_total . '</div>');

  // Determine how many assets will be deleted.
  $options['cql'] = strtr("retention_date < '@now' and retention_date_mail < '@days_ago'",
                    array(
                      '@now' => $now,
                      '@days_ago' => $days_ago,
                    )
  );
  $results = MediaMosaCkConnectorWrapper::search_asset($options);
  $form['retention_delete'] = array('#markup' => '<div>' . 'Number of rentention assets that will be deleted next cron: ' . $results->xml->header->item_count_total . '</div>');

  $form['testrun'] = array('#markup' => '<div>' . '<div>' . l(t('Perform a test run cron retention'), 'admin/config/media/uvt_retention/test_run', array('absolute' => TRUE)) . '</div>');

  return system_settings_form($form);
}
