#! /usr/bin/env perl

# $Id: Build.PL 44772 2016-03-03 10:36:30Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/libnet-ldap-schema-canonical-perl/Build.PL $

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST';
	find({wanted => sub { print $fh "$_\n" or die "write(MANIFEST): $!\n" if -f }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	module_name => 'Net::LDAP::Schema::Canonical',
	dist_name => 'libnet-ldap-schema-canonical-perl',
	dist_version => '1.0',
	dist_abstract => "Transform LDAP DNs and values to a canonical representation",
	dist_author => 'Wessel Dankers <wsl@uvt.nl>',
	license => 'perl',
	create_makefile_pl => 'small',
	script_files => [],
);

$build->create_build_script;
