#! /usr/bin/perl

# $Id: canonical.t 43958 2015-10-03 10:00:04Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/libnet-ldap-schema-canonical-perl/t/canonical.t $

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Net::LDAP::Schema::Canonical') or BAIL_OUT('need Net::LDAP::Schema::Canonical to run') }

foreach(
	[',', undef],
	['x=y,', undef],
	['x=y\\', undef],
	[',x=y', undef],
	[' x = y ,,,, a = b ', undef],
	['cn=\e3,c=b', undef],

	["surName=ILI\x{0106}", "sn=ili\x{0107}"],
	['OU=Sales+CN=J. Smith,O=Widget Inc.,C=US', 'cn=j. smith+ou=sales,o=widget inc.,c=us'],
	['CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB', 'cn=l. eagle,o=sue\, grabbit and runn,c=gb'],
	['oid.2.5.4.3="Te,st",C=GB', 'cn=te\,st,c=gb'],
	['a=b,y=z+v=w+t=u,a=b', 'a=b,t=u+v=w+y=z,a=b'],
	['y=z+v=w+t=u,a=b', 't=u+v=w+y=z,a=b'],
	['a=b,y=z+v=w+t=u', 'a=b,t=u+v=w+y=z'],
	['y=z+v=w+t=u', 't=u+v=w+y=z'],
	['x=#04024869', 'x=#04024869'],
	[' x =', 'x='],
	['x="\\\\"', 'x=\\\\'],
	[' x = ', 'x='],
	[' x = y ', 'x=y'],
	[' x = \#comment ', 'x=\#comment'],
	[' x = y ; a = b , q = p ', 'x=y,a=b,q=p'],
	[' x = y , a = b , q = ', 'x=y,a=b,q='],
	['x=y\  ', 'x=y\ '],
	['x=y\ ,a=b', 'x=y\ ,a=b'],
	['x=y\20,a=b', 'x=y\ ,a=b'],
	['x=\e3\81\82,a=b', "x=\x{3042},a=b"],
	['x=x\00y', 'x=x\00y'],
) {
	my ($input, $expect) = @$_;
	utf8::encode($input);
	utf8::encode($expect) if defined $expect;
	my $output = eval { Net::LDAP::Schema->canonicalize_dn($input) };
	warn "$input: $@" if !defined $output && defined $expect;
	is($output, $expect, "test a dn");
	is(eval { Net::LDAP::Schema->canonicalize_dn($output) }, $output, "test a dn (idempotent)")
		if defined $output;
}


done_testing();
