package Babelfish;
use strict;
use warnings  FATAL=> 'all';
use Carp qw(cluck carp longmess shortmess);

our @ISA=('Baseobject' );
use XML::LibXML;
use base qw(XML::LibXML::Document);
use utf8;
use Baseobject;
use Exporter;

sub new {
  my $pkg = shift;
  my $self = bless (new Baseobject(@_),$pkg);

  $self->allows( [ qw (language)]);
  $self->needs( [ qw (babelpoolNode )]);
  $self->fields(@_);
  $self->getbrowserlanguage();
  $self->checkneeds();
  $self;
}


sub translate {
	my ($self, $value, $attrs) = @_;
	# warn $self->inspect($attrhash);
	# warn "translating $self->{fields}->{language}, $value"  ;
	# attrhash asks for any attrib in the current language
	# par ex. {title=>1}
	my $attrhash;

	if (ref $value) {
		warn "value: $value is not a scalar!";
	}

	if (!defined ($attrs)) {
		$attrhash = {};
	}  elsif (ref ($attrs) eq 'ARRAY') {
		map {$attrhash->{$_} =1} (@$attrs);
	} else {
		$attrhash = $attrs;
	}



	my $h;
	# find first match only!
	my $node = 0;

	eval {
		($node)=$self->{fields}->{babelpoolNode}->findnodes($value);
	};

	if ($@) {
		warn "translate: findnodes($value) failed: $@";
		my ($package, $file, $line) = caller;
		die "Called from: $file line $line\n";
	}
	if ($node) {
		# first get specific language
		my (@langnodes) = $node->findnodes($self->{fields}->{language});
		if (@langnodes) {
			#value
			foreach my $langnode (@langnodes) {
				#multiline
				if (@langnodes > 1) {
					if ($langnode->nodeName()) {
						push (@{$h->{value}},$langnode->textContent());
					} else {
						push (@{$h->{value}},$value);
					}
				} else {
				    #singleline
					$h->{value} = $langnode->textContent();
				}
				fillattribs($value, $attrhash, $langnode, $h, scalar(@langnodes));
			}
		}
		else {
			# no language, try node content, else stick to the org value
			$h->{value} = $node->nodeName();
			$h->{value} = $value unless ($h->{value});
			fillattribs($value, $attrhash, $node, $h, 1);
		}
	} else {
		# nothing found, might want to write this to stderr?
		carp "babelfish: nothing found for: $value";
		$h->{value} = $value;
	}
	return $h if defined ($attrs);
	return $h->{value};
}

sub fillattribs
{
  my ( $value,$attrhash,$node,$h,$number)=@_;
  #attribs
  foreach my $attrib (keys %$attrhash)
  {
    my $attribvalue=$node->getAttribute($attrib);

    #multiline
    if ($number > 1)
    {
      if ($attribvalue)
      {
	push (@{$h->{$attrib}},$attribvalue);
      }
      else
      {
	push (@{$h->{$attrib}},undef) if ($attrhash->{$attrib}); # was: $h->{value}
      }
    }

    #singleline
    else
    {
      $h->{$attrib}=$attribvalue;
    }
    unless ($h->{$attrib})
    {
      $h->{$attrib}=undef if ($attrhash->{$attrib}); # was: $h->{value}
    }
  }
}


sub getbrowserlanguage
{
  my $self=shift;
  my $lan= lc($ENV{'HTTP_ACCEPT_LANGUAGE'});

  if ($self->{fields}->{language})
  {
    $self->debug( "request language: $self->{fields}->{language}");
    return 'en' if ($self->{fields}->{language} eq 'en');
    return 'nl' if ($self->{fields}->{language} eq 'nl');
  }
  $self->debug( "no requested language");

  #index not found returns -1
  my $nl = index ($lan,'nl')+1;
  my $en = index ($lan,'en')+1;
  my $res='en';

  if ($nl && $en)
  {
    if ($nl < $en)
    {
      $res='nl';
    }
  }
  elsif ($nl)
  {
    $res='nl';
  }
  $self->{fields}->{language}=$res;
#  warn "using language: $res";
  return $res;
}
