use strict;
use warnings FATAL => 'all';
use utf8;

package KUB::Windshield;

use KUB::Request;

use Xyzzy::Handler -self;

sub handle {
	local $SIG{__DIE__} = sub {
		local $_ = shift;
		die $_ if ref $_;
		if(s/^.*\K at \S+ line \d+\.?\n\z//) {
			local $Carp::CarpLevel = 1;
			confess($_);
		} else {
			die $_;
		}
	};

	my $res = eval { super };
	return $res if $res;
	my $exc = $@;
	die $exc if UNIVERSAL::isa($exc, 'Xyzzy::Response');
	my $req = new KUB::Request(cfg => $self, ctx => shift);
	warn $exc;
	$res = $req->error(internal => $exc);
	$res->status(500);
	die $res;
}
