use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::LDAP;

use Xyzzy::LDAP -self;

sub anr {
	my $uid = shift;
	my $cfg = $self->cfg;
	my $attribute = $cfg->anr_attribute;
	my $res = $self->search($uid, [$attribute]);
	my $count = $res->count;
	die "No LDAP entries for $uid\n"
		if $count == 0;
	die "Multiple ($count) LDAP entries for $uid\n"
		unless $count == 1;
	my $entry = $res->entry(0);
	my @values = $entry->get_value($attribute);
	$count = @values;
	die "LDAP entry for $uid has no ANR attribute\n"
		if $count == 0;
	die "LDAP entry for $uid has multiple ($count) ANR attributes\n"
		unless $count == 1;
	return pop @values;
}

sub displayname {
	my $anr = shift;
	my $cfg = $self->cfg;

	my $attribute = $cfg->anr_attribute;
	my $struct = {equalityMatch => {attributeDesc => $attribute, assertionValue => $anr}};

	# create a, possible cached, filter
	my $filter = $self->filter;
	$struct = {and => [$struct, $filter]}
		if $filter;

	my $search = bless($struct, 'Net::LDAP::Filter')->as_string;

	my $res = $self->connection->search(
			base => $self->base,
			filter => $search,
			attrs => [qw(uid cn mail)]
		);

	my $count = $res->count;
	die "No LDAP entries for $anr\n"
		if $count == 0;
	die "Multiple ($count) LDAP entries for $anr\n"
		unless $count == 1;
	my $entry = $res->entry(0);
	my $uid = $entry->get_value('uid')
		or die "LDAP entry for $anr has no uid attribute\n";
	my $cn = $entry->get_value('cn')
		or die "LDAP entry for $anr has no cn attribute\n";
	my $mail = $entry->get_value('mail')
		or die "LDAP entry for $anr has no mail attribute\n";
	
	return {uid => $uid, cn => $cn, mail => $mail};
}
