use utf8;
use strict;
use warnings FATAL => 'all';

package KUB::Manage::Document;

use KUB::Document -self;

sub hash2els() {
	my $h = shift;
	my @res;
	while(my ($k, $v) = each(%$h)) {
		push @res, [$k => $v];
	}
	return @res;
}

sub build {
	my $req = $self->req;

	my $mode = defined $req->remove ? 'remove' : $req->edit_valid ? 'edit' : 'add';
	my $stage = $req->success ? 'done' : 'input';

	my $root = $self->construct(manage =>
		[mode => $mode],
		[stage => $stage],
		[user =>
			[uid => $req->login],
			[anr => $req->anr],
		],
	);

	my $nonce = $req->create_nonce;
	if(defined $nonce) {
		$root->appendChild($self->construct(nonce => $nonce));
	}

	if(defined $req->cur_name) {
		my $entry = $self->createElement('entry');
		if(defined(my $name = $req->new_name)) {
			$entry->appendChild($self->construct(name => $name));
		}
		if(defined(my $url = $req->new_url)) {
			$entry->appendChild($self->construct(url => $url));
		}
		$entry->appendChild($self->construct(private => $req->private ? 'true' : 'false'));
		$root->appendChild($entry);
	} else {
		$root->appendChild($self->construct(urls => map {
			[url =>
				[num => $_->num],
				[name => $_->name],
				[destination => $_->destination],
				[private => $_->private ? 'true' : 'false'],
				[visits => $_->visits],
				[ctime => $_->ctime],
				[mtime => $_->mtime],
				$_->atime ? [atime => $_->atime] : (),
			]
		} @{$req->urls}));
		$root->appendChild($self->construct(random => $req->random_name));
	}

	my $feedback = $req->feedback;
	if(@$feedback) {
		$root->appendChild($self->construct(feedback => map {
			my ($name, $info) = @$_;
			[$name => hash2els($info)]
		} @$feedback));
	}

	if(my $edit = $req->new_edit) {
		my $owner = $req->edit_owner;
		my $name = $req->edit_name;
		my $url = $req->edit_destination;
		$root->appendChild($self->construct(edit =>
			[num => $edit],
			defined $owner ? [owner => $owner] : (),
			defined $name ? [name => $name] : (),
			defined $url ? [url => $url] : (),
		));
	}

	$self->setDocumentElement($root);
}
