function log(msg) {
	if(window.console)
		console.debug(msg);
	else
		setTimeout(function() { throw new Error(msg) }, 0);
}

$(document).ready(function() {
	$('#mainContentContainer').height('auto');

	var $searchForm = $('#searchForm');
	if(!$searchForm.length)
		return;

	var $searchTextInput = $('#searchTextInput');
	$searchTextInput.focus();

	var $kikiAlias = $('#kikiAlias');

	var nonce;
	var domains_by_name;

	function qnonce() {
		return '?nonce=' + encodeURIComponent(nonce);
	}

	var feedback_texts = {
		'session': "Your session expired. Please reload the page.",
		'unknown-alias': "Can't find an alias by this name.",
		'malformed': "Specified name is malformed.",
		'too-long': "Specified name is too long.",
		'stored': "Alias saved.",
		'empty-name': "Name required.",
		'empty-domain': "Domain required.",
		'empty-addressbook': "Addressbook not specified.",
		'empty-destinations': "No destinations specified.",
		'alias-exists': "This alias already exists – refusing to overwrite. Please edit the existing alias instead.",
		'unknown-anr': "Unknown ANR.",
		'multiple': "Only one e-mail address allowed per field.",
		'invalid-address': "Invalid e-mail address.",
		'unknown-alias': "Unknown alias.",
		'unknown-domain': "Domain cannot be resolved.",
		'not-unique': "This name exists in multiple domains.",
		'person': "Attempt to update a personal record.",
		'has-referrers': "Alias is still in use by other aliases. Hint: search for the full address to see all referrers."
	};

	function feedback_text(k) {
		if(k === undefined)
			return '';
		var t = feedback_texts[k];
		return t === undefined ? k : t;
	}

	function bool2text(b, f) {
		if(b === true)
			return 'true';
		if(b === false)
			return 'false';
		return f;
	}

	function text2bool(b, f) {
		if(b === 'true')
			return true;
		if(b === 'false')
			return false;
		return f;
	}

	function sortedEach(a, f) {
		var ks = [];
		for(var k in a)
			ks.push(k);
		ks.sort();
		var len = ks.length;
		var res = [];
		for(var i = 0; i < len; i++) {
			var k = ks[i];
			res.push(f(i, k, a[k]));
		}
	}

	function domainDisplayName(names) {
		var len = names.length;
		var name = names[0];
		if(len > 1) {
			var sep = ' (';
			for(var i = 1; i < len; i++) {
				name += sep;
				name += names[i];
				sep = ', ';
			}
			name += ')';
		}
		return name;
	}

	function full(a) {
		return a.address ? a.address : a.name + '@' + a.domain;
	}

	function inputColor($input, orig, good, bad) {
		var val = $input.val();
		var color = '#ffe';
		if(val === bad)
			color = '#fee';
		else if(val === orig)
			color = '#fff';
		else if(val === good)
			color = '#efe';
		else if(orig === undefined && val === '')
			color = '#fff';
		$input.css('background-color', color);
	}

	function onChange($input, handler) {
		$input.change(handler);
		$input.keyup(handler);
		$input.keydown(handler);
		$input.blur(handler);
		$input.bind('input', handler);
		$input.bind('propertychange', handler);
	}

	function ExpandedDestination(alias, v) {
		var id = this.id = 'dst-' + alias.generate_id();
		var input = this.input = html('input', {type: 'text', name: 'destination', value: v, placeholder: "New destination…"});
		var $input = this.$input = $(input);
		var clear = this.clear = html('span', {'class': 'clear-destination'}, '×');
		var $clear = this.$clear = $(clear);
		var feedback = this.feedback = html('span', {'class': 'negative-feedback'});
		var $feedback = this.$feedback = $(feedback);
		var div = this.div = html('div', clear, input, feedback);
		var $div = this.$div = $(div);

		this.orig = v;
		this.alias = alias;
		var destinations_by_id = alias.destinations_by_id;
		destinations_by_id[id] = this;

		var self = this;

		$clear.click(function() {
			if($input.val() != '')
				self.remove();
		});

		onChange($input, function() {
			inputColor($input, self.orig, self.good, self.bad);
			if($input.val() == '') {
				for(var k in destinations_by_id) {
					var d = destinations_by_id[k];
					if(d.id != id && d.$input.val() == '')
						d.remove();
				}
			} else {
				var have_empty = false;
				for(var k in destinations_by_id) {
					var d = destinations_by_id[k];
					if(d.id != id && d.$input.val() == '') {
						have_empty = true;
						break;
					}
				}
				if(!have_empty)
					alias.addExpandedDestination('');
			}
		});
	}

	ExpandedDestination.prototype.remove = function() {
		var div = this.div;
		this.$div.slideUp('fast', function(){div.parentNode.removeChild(div)});
		delete this.alias.destinations_by_id[this.id];
	}

	function PersonWidget(person) {
		var self = this;

		var canonical = full(person);

		var compacted_addresses = html('div', ['div', ['strong', canonical]]);
		$.each(person.names, function(i, d) {
			var c = full(d);
			if(c != canonical)
				compacted_addresses.appendChild(html('div', c));
		});

		var compacted_dst = html('p', {'class': 'summary'});

		$.each(person.destinations, function(i, d) {
			compacted_dst.appendChild(html('span',
				['span', {'class': 'userTypeImage mailbox'}], d + ' '
			));
		});

		this.div = html('div', {'class': 'entry'},
			['table', {'class': 'layout'}, ['tr',
				['td', {'class': 'column left'}, ['span', {'class': 'userTypeImage person'}]],
				['td', {'class': 'column from'}, compacted_addresses],
				['td', {'class': 'column to'}, compacted_dst],
				['td', {'class': 'column right'}, "\xA0"]
			]]
		);
	}

	function AliasWidget(alias) {
		var self = this;

		if(alias === undefined)
			alias = {domain: 'uvt.nl', destinations: []};

		/* in MSIE is 'class' een keyword, altijd kwoten dus */
		var compacted_dst = this.compacted_dst = html('p', {'class': 'summary clickable'});
		var $compacted_dst = this.$compacted_dst = $(compacted_dst);

		/* Icons for the "expand" and "collapse" actions. */
		var compacted_img = this.compacted_img = html('div', ['img', {src: 'static/expand.png', alt: 'show', 'class': 'foldimg showimg'}]);
		var $compacted_img = this.$compacted_img = $(compacted_img);
		var img_container = html('div', {'class': 'foldimg'}, compacted_img);
		var $img_container = self.$img_container = $(img_container);

		var delete_btn = html('button', {type: 'button', name: 'delAlias'}, "Delete");

		var compacted_btn = this.compacted_btn = html('div', {'class': 'compacted'}, delete_btn);
		var $compacted_btn = this.$compacted_btn = $(compacted_btn);

		var compacted_name = this.compacted_name = html('strong');
		var $compacted_name = this.$compacted_name = $(compacted_name);
		var compacted_address = this.compacted_address = html('div', {'class': 'clickable'}, compacted_name);
		var $compacted_address = this.$compacted_address = $(compacted_address);

		$(delete_btn).click(function() {
			self.jit();
			if(self.alias.name === undefined)
				return;
			if(!confirm("Are you sure you want to delete the alias " + full(self.alias) + "?"))
				return;
			var url = 'alias/'+full(self.alias) + qnonce();
			$.ajax({
				url: url,
				dataType: 'json',
				success: function(data) {
					var note = data.note;
					if(note[0] == 'ok') {
						$(self.div).slideUp('fast');
					} else {
						self.feedback.className = 'negative-feedback';
						self.$feedback.text(feedback_text(note[1]));
						setTimeout(function() { self.show() }, 0);
					}
				},
				type: 'DELETE'
			});
		});

		$img_container.click(function(){ self.toggle() });
		$compacted_dst.click(function(){ self.show() });
		$compacted_address.click(function(){ self.show() });

		address_container = html('div', compacted_address);
		self.$address_container = $(address_container);

		dst_container = html('td', {'class': 'column to'}, compacted_dst);
		self.$dst_container = $(dst_container);
		btn_container = html('td', {'class': 'column right'}, compacted_btn);
		self.$btn_container = $(btn_container);

		var div = this.div = html('div', {'class': 'entry'},
			['form', {'class': 'editAlias', action: 'javascript:'},
				['table', {'class': 'layout'}, ['tr',
					['td', {'class': 'column left'}, ['div', img_container]],
					['td', {'class': 'column from'}, address_container],
					dst_container, btn_container
				]]
			]
		);
		this.$div = $(div);

		this.setAlias_lazy(alias);
	}

	AliasWidget.prototype.jit = function() {
		this.jit = function(){};

		var self = this;
		var alias = self.alias;

		var next_id = 0;
		this.generate_id = function() { return next_id++ };

		var expanded_dst = this.expanded_dst = html('div', {'class': 'expanded'});
		var $expanded_dst = this.$expanded_dst = $(expanded_dst);
		this.$dst_container.append(expanded_dst);

		this.destinations_by_id = {};

		var expanded_img = this.expanded_img = html('div', ['img', {src: 'static/collapse.png', alt: 'hide', 'class': 'foldimg hideimg'}]);
		var $expanded_img = this.$expanded_img = $(expanded_img);
		self.$img_container.append(expanded_img);

		var domain = this.domain = html('select', {name: 'domain', 'class': 'domains'});
		var $domain = this.$domain = $(domain);
		sortedEach(domains_by_name, function(i, name, domain) {
			$domain.append(html('option', {value: name}, domainDisplayName(domain)));
		});

		onChange($domain, function() {inputColor($domain, self.alias.domain, self.gooddomain, self.baddomain)});

		var name = this.name = html('input', {type: 'text', name: 'name', 'class': 'name', placeholder: "Name…", maxlength: 64});
		var $name = this.$name = $(name);

		onChange($name, function() {inputColor($name, self.alias.name, self.goodname, self.badname)});

		var submit_btn = html('button', {type: 'button', 'class': 'saveButton', name: 'saveAlias'}, ['strong', "Save"]);
		var reset_btn = html('button', {type: 'button', 'class': 'resetButton', name: 'resetAlias'}, "Reset");

		var expanded_btn = this.expanded_btn = html('div', {'class': 'expanded'}, reset_btn, submit_btn);
		var $expanded_btn = this.$expanded_btn = $(expanded_btn);
		this.$btn_container.append(expanded_btn);

		var feedback = this.feedback = html('span', {'class': 'negative-feedback'});
		var $feedback = this.$feedback = $(feedback);

		var addressbook = this.addressbook = html('select', {name: 'addressbook', 'class': 'addressbook'},
			['option', {value: '', disabled: 'disabled', selected: 'selected'}, "Address book?"],
			['option', {value: 'true'}, "Show in address book"],
			['option', {value: 'false'}, "Do not show in address book"]
		);
		var $addressbook = this.$addressbook = $(addressbook);

		onChange($addressbook, function() {inputColor($addressbook, bool2text(self.alias.addressbook), self.goodaddressbook, self.badaddressbook)});

	 	var expanded_address = this.expanded_address = html('div', ['div', name, '@', domain], ['div', addressbook], ['p', feedback]);
		var $expanded_address = this.$expanded_address = $(expanded_address);
		this.$address_container.append(expanded_address);

		$(reset_btn).click(function() {
			if(!confirm("Undo pending changes?"))
				return;
			self.setAlias(self.alias);
		});

		$(submit_btn).click(function() {
			var addresses = [];
			var destinations = [];
			var ab = $addressbook.val();
			var postdata = {
				name: $name.val(),
				domain: $domain.val(),
				destinations: addresses,
				addressbook: text2bool(ab, null)
			};
			var destinations_by_id = self.destinations_by_id;
			for(var k in destinations_by_id) {
				var d = destinations_by_id[k];
				destinations.push(d);
				addresses.push(d.$input.val());
			}
			function success(data) {
				var note;
				var notes = data.notes;
				if(notes.update[0] == 'ok') {
					if(self.alias.name === undefined) {
						var widget = new AliasWidget({domain: data.alias.domain, destinations: []});
						widget.$div.hide();
						$kikiAlias.append(widget.div);
						widget.$div.slideDown('fast');
					}
					self.setAlias(data.alias);
					self.feedback.className = 'positive-feedback';
					self.$feedback.text(feedback_text('stored'));
					self.hide();
				} else {
					var dnotes = notes.destinations;
					var len = destinations.length;
					for(var i = 0; i < len; i++) {
						note = dnotes[i];
						var d = destinations[i];
						if(note[0] == 'ok') {
							d.good = note[2];
							d.$input.val(note[2]);
							destinations[i].$feedback.text('');
						} else {
							d.bad = addresses[i];
							d.$feedback.text(feedback_text(note[1]));
						}
						inputColor(d.$input, d.orig, d.good, d.bad);
					}

					self.feedback.className = 'negative-feedback';
					$feedback.text(feedback_text(notes.update[1]));

					note = notes.name;
					if(note[0] == 'ok') {
						self.goodname = note[2];
						$name.val(note[2]);
					} else {
						self.badname = postdata.name;
						$feedback.text(feedback_text(note[1]));
					}
					inputColor($name, self.alias.name, self.goodname, self.badname);

					note = notes.domain;
					if(note[0] == 'ok') {
						self.gooddomain = note[2];
						$domain.val(note[2]);
					} else {
						self.baddomain = postdata.domain;
						$feedback.text(feedback_text(note[1]));
					}
					inputColor($domain, self.alias.domain, self.gooddomain, self.baddomain);

					note = notes.addressbook;
					if(note[0] == 'ok') {
						var ab = bool2text(note[2]);
						$addressbook.val(ab);
						self.goodaddressbook = ab;
					} else {
						self.badaddressbook = '';
						$feedback.text(feedback_text(note[1]));
					}
					inputColor($addressbook, bool2text(self.alias.addressbook), self.goodaddressbook, self.badaddressbook);
				}
			}
			var url = self.alias.name === undefined
				? 'alias' + qnonce()
				: 'alias/' + full(self.alias) + qnonce();
			$.ajax({
				url: url,
				data: JSON.stringify(postdata),
				contentType: 'application/json',
				dataType: 'json',
				success: success,
				type: 'POST'
			});
		});

		$expanded_dst.hide();
		$expanded_address.hide();
		$expanded_btn.hide();
		$expanded_img.hide();

		this.setAlias(alias);
	}

	AliasWidget.prototype.show = function() {
		this.jit();
		this.$compacted_dst.slideUp('fast');
		this.$expanded_dst.slideDown('fast');    
		this.$compacted_address.slideUp('fast');    
		this.$expanded_address.slideDown('fast');    
		this.$expanded_btn.slideDown('fast');    
		this.$compacted_img.hide();
		this.$expanded_img.show();
	}

	AliasWidget.prototype.hide = function() {
		this.jit();
		this.$compacted_dst.slideDown('fast');
		this.$expanded_dst.slideUp('fast');    
		this.$compacted_address.slideDown('fast');    
		this.$expanded_address.slideUp('fast');    
		this.$expanded_btn.slideUp('fast');    
		this.$compacted_img.show();
		this.$expanded_img.hide();
	}

	AliasWidget.prototype.toggle = function() {
		this.jit();
		this.$compacted_dst.slideToggle('fast');    
		this.$expanded_dst.slideToggle('fast');    
		this.$compacted_address.slideToggle('fast');    
		this.$expanded_address.slideToggle('fast');    
		this.$expanded_btn.slideToggle('fast');    
		this.$compacted_img.toggle();
		this.$expanded_img.toggle();
	}

	AliasWidget.prototype.addExpandedDestination = function(v) {
		this.expanded_dst.appendChild(new ExpandedDestination(this, v).div);
	}

	AliasWidget.prototype.setAlias_lazy = function(alias) {
		this.alias = alias;

		if(alias.name === undefined) {
			this.$compacted_name.text("Add a new alias…");
			this.$compacted_btn.hide();
		} else {
			this.$compacted_name.text(full(alias));
			this.$compacted_btn.slideDown('fast');
		}

		var $compacted_dst = this.$compacted_dst;
		$compacted_dst.empty();
		var compacted_dst = this.compacted_dst;
		$.each(alias.destinations, function(i, d) {
			compacted_dst.appendChild(html('span', {style: 'display: inline-block'},
				['span', {'class': 'userTypeImage ' + d.type}],
				full(d) + '\xA0\xA0'
			));
		});
	}

	AliasWidget.prototype.setAlias = function(alias) {
		this.setAlias_lazy(alias);

		this.$name.val(alias.name === undefined ? '' : alias.name);

		this.goodname = undefined;
		this.badname = undefined;
		inputColor(this.$name, alias.name);

		this.$domain.val(alias.domain);
		this.gooddomain = undefined;
		this.baddomain = undefined;
		inputColor(this.$domain, alias.domain);

		this.goodaddressbook = undefined;
		this.badaddressbook = undefined;
		if(alias.addressbook === undefined) {
			this.$addressbook.val('');
			inputColor(this.$addressbook);
		} else {
			var ab = bool2text(alias.addressbook);
			this.$addressbook.val(ab);
			inputColor(this.$addressbook, ab);
		}

		this.destinations_by_id = {};
		$(this.expanded_dst).empty();
		var self = this;
		$.each(alias.destinations, function(i, d) {
			self.addExpandedDestination(full(d));
		});
		self.addExpandedDestination('');
	}

	function searchResult(data) {
		$kikiAlias.empty();

		var results = data.results;
		for(var i = 0; i < results.length; i++) {
			var alias = results[i];
			var widget = alias.type == 'person'
				? new PersonWidget(alias)
				: new AliasWidget(alias);
			$kikiAlias.append(widget.div);
		}
		if(!results.length && data.query !== '') {
			$kikiAlias.append(html('p', {'class': 'search-feedback'},
				['span', {'class': 'negative-feedback search-feedback'},
					"No matching aliases found"]));
		}
		var create = new AliasWidget();
		$kikiAlias.append(create.div);
	}

	function zoek() {
		var q = $searchTextInput.val();
		window.location.hash = '#' + encodeURIComponent(q);
		$.ajax({
			url: 'search',
			data: { q: q },
			success: searchResult,
			dataType: 'json',
			type: 'GET'
		});
	}

	function getNonce() {
		$.ajax({
			url: 'nonce',
			success: function(data) { nonce = data.nonce },
			error: function(data) { if(confirm("Your session seems to have expired. You need to reload the page to be able to continue, but doing so will undo any pending changes you have made. Reload now?")) location.reload() },
			dataType: 'json',
			type: 'GET'
		});
	}

	getNonce();
	setInterval(getNonce, 1800000);

	function domeinenGeladen(data) {
		domains_by_name = {};
		var domains = data.domains;
		for(var i = 0; i < domains.length; i++) {
			var names = domains[i];
			domains_by_name[names[0]] = names;
		}

		var q = window.location.hash;
		if(q)
			q = decodeURIComponent(q.substr(1));
		if(q) {
			$searchTextInput.val(q);
			zoek();
		} else {
			var widget = new AliasWidget();
			$kikiAlias.append(widget.div);
		}
	}

	$.ajax({
		url: 'domains',
		success: domeinenGeladen,
		dataType: 'json',
		type: 'GET'
	});

	$(window).bind('hashchange', function() {
		var q = window.location.hash;
		if(q)
			q = decodeURIComponent(q.substr(1));
		if(q == $searchTextInput.val())
			return;
		if(q) {
			$searchTextInput.val(q);
			zoek();
		} else {
			var widget = new AliasWidget();
			$kikiAlias.append(widget.div);
		}
	});

	$searchForm.submit(zoek);
});
