<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ss="http://tilburguniversity.edu/stylesheets">

	<xsl:param name="script_url"/>

	<xsl:template match="/">
		<ss:root>
			<ss:head>
				<base href="{$script_url}/"/>
				<script type="text/javascript" src="static/lang.js"/>
				<script type="text/javascript" src="static/json2.js"/>
				<script type="text/javascript" src="static/xml.js"/>
				<script type="text/javascript" src="static/app.js"/>
				<link rel="stylesheet" href="static/app.css" type="text/css"/>
			</ss:head>

			<ss:keywords>mailaliassen mailalias mail alias functioneel</ss:keywords>
			<ss:description>Tilburg University mail alias management</ss:description>
			<ss:title><xsl:apply-templates mode="title"/>Mail alias management</ss:title>

			<ss:colorbar>
				<ss:color>blue</ss:color>
				<ss:title>Mail alias management</ss:title>
				<ss:message>Create, update and delete functional mail aliases</ss:message>
				<ss:panels>
					<ss:panel>
						<ss:link>manual</ss:link>
						<ss:image>static/lolwut.png</ss:image>
						<ss:message>Quick Start guide</ss:message>
						<ss:color>Green</ss:color>
					</ss:panel>
					<ss:panel>
						<ss:link>mailto:lis-unix@uvt.nl</ss:link>
						<ss:image>static/supdawg.png</ss:image>
						<ss:message>Contact us</ss:message>
						<ss:color>Grey</ss:color>
					</ss:panel>
				</ss:panels>
			</ss:colorbar>

			<!-- disabled
			<ss:languages>
				<ss:language>
					<ss:code>en</ss:code>
					<ss:target>javascript:setlang('en')</ss:target>
				</ss:language>
				<ss:language>
					<ss:code>nl</ss:code>
					<ss:target>javascript:setlang('nl')</ss:target>
				</ss:language>
			</ss:languages>
			-->

			<ss:content>
				<xsl:apply-templates/>
			</ss:content>
		</ss:root>
	</xsl:template>

	<!-- prevent extraneous text from showing up -->
	<xsl:template match="text()"/>
</xsl:stylesheet>
