<?php

/*
 * FileSender www.filesender.org
 * 
 * Copyright (c) 2009-2012, AARNet, Belnet, HEAnet, SURFnet, UNINETT
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * *	Redistributions of source code must retain the above copyright
 * 	notice, this list of conditions and the following disclaimer.
 * *	Redistributions in binary form must reproduce the above copyright
 * 	notice, this list of conditions and the following disclaimer in the
 * 	documentation and/or other materials provided with the distribution.
 * *	Neither the name of AARNet, Belnet, HEAnet, SURFnet and UNINETT nor the
 * 	names of its contributors may be used to endorse or promote products
 * 	derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* --------------------------------------------------------------
 * it_IT Language File
 * Contributed by 
 * 		Fabio Spelta - Sistemi Informativi, Università degli Studi di Milano-Bicocca
 * 		Riccardo Valzorio - CILEA
 * --------------------------------------------------------------
 */
// main menu items
$lang["_ADMIN"] = "Amministrazione";
$lang["_NEW_UPLOAD"] = "Invia un file";
$lang["_VOUCHERS"] = "Invia un voucher";
$lang["_LOGON"] = "Login";
$lang["_LOG_OFF"] = "Logout";
$lang["_MY_FILES"] = "I miei file";

// page titles
$lang["_HOME"] = "Pagina principale";
$lang["_ABOUT"] = "Informazioni";
$lang["_HELP"] = "Aiuto";
$lang["_DELETE_VOUCHER"] = "Elimina l'invito";
$lang["_UPLOAD_COMPLETE"] = "Il tuo file è stato caricato e il messaggio inviato";
$lang["_UPLOAD_PROGRESS"] = "Caricamento in corso";
$lang["_DOWNLOAD"] = "Download";
$lang["_CANCEL_UPLOAD"] = "Annulla l'upload";

// admin
$lang["_PAGE"] = "Pagina";
$lang["_UP"] = "Su";
$lang["_DOWN"] = "Giù";
$lang["_FILES"] = "File";
$lang["_DRIVE"] = "Spazio";
$lang["_TOTAL"] = "Totale";
$lang["_USED"] = "Utilizzato";
$lang["_AVAILABLE"] = "Disponibile";
$lang["_TEMP"] = "Temporaneo"; // as in Temporary files

$lang["_WELCOME"] = "Benvenuto"; 
$lang["_WELCOMEGUEST"] = "Benvenuto ospite"; 

// admin tab names
$lang["_GENERAL"] = "Generale";
$lang["_UPLOADS"] = "File scaricati";
$lang["_DOWNLOADS"] = "File caricati";
$lang["_ERRORS"] = "Errori";
$lang["_FILES_AVAILABLE"] = "File disponibili";
$lang["_ACTIVE_VOUCHERS"] = "Voucher attivi";
$lang["_COMPLETE_LOG"] = "Log completi";

// Form Fields
$lang["_TO"] = "A";
$lang["_FROM"] = "Da";
$lang["_SIZE"] = "Dimensione";
$lang["_CREATED"] = "Data di creazione";
$lang["_FILE_NAME"] = "Nome del file";
$lang["_SUBJECT"] = "Oggetto";
$lang["_EXPIRY"] = "Scadenza";
$lang["_MESSAGE"] = "Messaggio";
$lang["_TYPE"] = "Tipo";

$lang["_TERMS_OF_AGREEMENT"] = "Termini di utilizzo";
$lang["_SHOW_TERMS"] = "Mostra i termini";
$lang["_SHOWHIDE"] = "Mostra/Nascondi";
$lang["_UPLOADING_WAIT"] = "Caricamento del file - attendere...";

// Flash button menu
$lang["_UPLOAD"] = "Invia un file";
$lang["_BROWSE"] = "Scegli...";
$lang["_CANCEL"] = "Elimina";
$lang["_OPEN"] = "Apri";
$lang["_CLOSE"] = "Chiudi";
$lang["_OK"] = "OK";
$lang["_SEND"] = "Invia";
$lang["_DELETE"] = "Elimina";
$lang["_YES"] = "Sì";
$lang["_NO"] = "No";

$lang["_INVALID_MISSING_EMAIL"] = "Indirizzo email non valido";
$lang["_INVALID_EXPIRY_DATE"] = "Data di scadenza non valida";
$lang["_INVALID_FILE"] = "File non valido";
$lang["_INVALID_FILEVOUCHERID"] = "File o voucher non valido";
$lang["_INVALID_FILESIZE_ZERO"] = "La dimensione del file non può essere zero. Per favore seleziona un altro file.";
$lang["_INVALID_FILE_EXT"] = "Estensione del file non valida.";
$lang["_INVALID_TOO_LARGE_1"] = "La dimensione del file non può essere superiore a";
$lang["_AUTH_ERROR"] = "Non sei più autenticata/o. <br />La tua sessione potrebbe essere scaduta o potrebbe essersi verificato un errore sul server. <br /><br />Per cortesia effettua di nuovo il login e riprova.";
$lang["_SELECT_ANOTHER_FILE"] = "Per favore seleziona un altro file.";
$lang["_INVALID_VOUCHER"] = "Questo voucher non è più valido. <br />Per cortesia contatta la persona che ha rilasciato questo voucher.";
$lang["_SELECT_FILE"] = "Seleziona il tuo file.";
$lang["_INVALID_FILE_NAME"] = "Il nome del file che vuoi caricare non è valido. Per cortesia rinomina il file e prova di nuovo.";
$lang["_INVALID_SIZE_USEHTML5"] = "Per favore seleziona un altro file o usa un browser che supporti HTML5 per caricare file di dimensioni maggiori.";
$lang["_ACCEPTTOC"] = "Accetto i termini e le condizioni di questo servizio.";
$lang["_AGREETOC"] = "DEVI accettare i termini e le condizioni.";
$lang["_FILE_TO_BE_RESENT"] = "File to be redistributed";
$lang["_ERROR_UPLOADING_FILE"] = "Errore nel caricamento del file";
$lang["_ERROR_SENDING_EMAIL"] = "Si è verificato un errore nell'invio delle email, si prega di contattare il tuo amministratore";
$lang["_ERROR_INCORRECT_FILE_SIZE"] = "Si è verificato un errore durante il caricamento del file. <br />La dimensione del file sul server è differente da quella del file originale.<br /><br />Contatta il tuo amministratore.";
$lang["_MAXEMAILS"] = "Il numero massimo di indirizzi email è ";
$lang["_INVALID_DATE_FORMAT"] = "Il formato della data non è valido";
$lang["_DISK_SPACE_ERROR"] = "Non c'è sufficiente spazio disco su questo server. Per favore contatta l'amministrazione del servizio o carica un file di dimensioni minori.";
$lang["_ERROR_ATTRIBUTES"] = "Il tuo identity provider non sta rilasciando gli attributi richiesti. Contatta il tuo amministratore";
$lang["_PERMISSION_DENIED"] = "Non hai l\'autorizzazione per fare questo.";
$lang["_ERROR_CONTACT_ADMIN"] = "Si è verificato un errore, si prega di contattare il tuo amministratore";

// Logout page
$lang["_LOGOUT_COMPLETE"] = "Logout completato.";

// vouchers
$lang["_SEND_NEW_VOUCHER"] = "Un voucher consente a un'altra persona di inviarti un file.<br />
Per creare un voucher, inserisci un indirizzo email e seleziona <b>Invia voucher</b>.<br />
Il destinatario riceverà un'email contenente il link per utilizzare il voucher.";
$lang["_EMAIL_SEPARATOR_MSG"] = "Indirizzi di posta elettronica separati da , o ;";

$lang["_NO_FILES"] = "Al momento non ci sono file disponibili.";
$lang["_NO_VOUCHERS"] = "Al momento non ci sono voucher disponibili";
$lang["_ARE_YOU_SURE"] = "Sei sicura/o?";
$lang["_DELETE_FILE"] = "Elimina File";
$lang["_EMAIL_SENT"] = "Messaggio Inviato";
$lang["_EXPIRY_DATE"] = "Data di scadenza";
$lang["_FILE_SIZE"] = "Dimensione del file";
$lang["_FILE_RESENT"] = "File reinviato";
$lang["_MESSAGE_RESENT"] = "Messaggio reinviato";
$lang["_ME"] = "Io";
$lang["_SEND_VOUCHER"] = "Invia voucher";
$lang["_RE_SEND_EMAIL"] = "Reinvia Email";
$lang["_NEW_RECIPIENT"] = "Aggiungi un nuovo destinatario";
$lang["_SEND_VOUCHER_TO"] = "Invia i voucher a";
$lang["_START_DOWNLOAD"] = "Inizia lo scaricamento";
$lang["_VOUCHER_SENT"] = "Voucher inviato";
$lang["_VOUCHER_DELETED"] = "Voucher eliminato";
$lang["_VOUCHER_CANCELLED"] = "Questo Voucher è stato annullato.";
$lang["_VOUCHER_USED"] = "Questo Voucher è già stato utilizzato.";
$lang["_STARTED_DOWNLOADING"] = "Lo scaricamento del tuo file dovrebbe iniziare.";
$lang["_FILE_DELETED"] = "File eliminato";

// steps
$lang["_STEP1"] = "Inserisci l'indirizzo destinatario";
$lang["_STEP2"] = "Imposta la data di scadenza";
$lang["_STEP3"] = "Allega il file";
$lang["_STEP4"] = "Clicca Invia";
$lang["_HTML5Supported"] = "I file più grandi di 2GB sono supportati!";
$lang["_HTML5NotSupported"] = "I file più grandi di 2GB non sono supportati!";

$lang["_OPTIONAL"] = "opzionale";

// confirmation
$lang["_CONFIRM_DELETE_FILE"] = "Sei sicura/o di voler eliminare questo file?";
$lang["_CONFIRM_DELETE_VOUCHER"] = "Sei sicura/o di voler eliminare questo voucher?";
$lang["_CONFIRM_RESEND_EMAIL"] = "Sei sicuro di voler reinviare questa email?";

// standard date display format
$lang['datedisplayformat'] = "d/m/Y"; // Format for displaying date/time, use PHP date() format string syntax 

// datepicker localization
$lang["_DP_closeText"] = 'Fatto'; // Done
$lang["_DP_prevText"] = 'Prec'; //Prev
$lang["_DP_nextText"] = 'Prox'; // Next
$lang["_DP_currentText"] = 'Oggi'; // Today
$lang["_DP_monthNames"] = "['gennaio','febbraio','marzo','aprile','maggio','giugno','luglio','agosto','settembre','ottobre','novembre','dicembre']";
$lang["_DP_monthNamesShort"] = "['gen', 'feb', 'mar', 'apr', 'mag', 'giu','lug', 'ago', 'set', 'ott', 'nov', 'dic']";
$lang["_DP_dayNames"] = "['domenica', 'lunedì', 'martedì', 'mercoledì', 'giovedì', 'venerdì', 'sabato']";
$lang["_DP_dayNamesShort"] = "['dom', 'lun', 'mar', 'mer', 'gio', 'ven', 'sab']";
$lang["_DP_dayNamesMin"] = "['do','lu','ma','me','gi','ve','sa']";
$lang["_DP_weekHeader"] = 'Wk';
$lang["_DP_dateFormat"] = 'dd/mm/yy';
$lang["_DP_firstDay"] = '1';
$lang["_DP_isRTL"] = 'false';
$lang["_DP_showMonthAfterYear"] = 'false';
$lang["_DP_yearSuffix"] = '';

// Login Splash text
$lang["_SITE_SPLASHHEAD"] = "Benvenuto su ". htmlspecialchars($config['site_name']);
$lang["_SITE_SPLASHTEXT"] = htmlspecialchars($config['site_name']) ." è un modo sicuro di condividere grossi file con tutti! Premete Logon per caricare i vostri file o invitare persone a spedirvene uno.";

// Footer to display
$lang["_SITE_FOOTER"] = ""; 

// site help
$lang["_HELP_TEXT"] = '
<div>
<div align="left" style="padding:5px">
<h4>Login</h4> 
<ul>
    <li>Se non visualizzi la tua istutuzione nella lista degli Identity Provider(IdPs) o il login istituzionale fallisce, contatta il supporto del tuo dipartimento IT.</li> 
</ul>

<h4>Uploads di <i>qualsiasi dimensione</i> con HTML5</h4>
<ul>
        <li>Se visualizzi <img src="images/html5_installed.png" alt="green HTML5 tick" class="textmiddle" style="display:inline" /> questa modalità funziona per te</li>
        
        <li>Devi utilizzare un browser molto recente per usufruire di HTML5, l\'ultima versione de "il linguaggio della rete".</li>
        <li>Attualmente Firefox 4 (o versioni superiori) e Chrome per Windows, Mac OS X e Linux funzionano correttamente</li>
        <li>Per favore utilizza il sito <a href="http://caniuse.com/fileapi" target="_blank">"When can I use..."</a> per monitorare lo stato di sviluppo delle HTML5 FileAPI per la maggiorparte dei browser. Specialmente <a href="http://caniuse.com/filereader" target="_blank">FileReader API</a> and <a href="http://caniuse.com/bloburls" target="_blank">Blob URLs</a> devono essere verdi (=supporati) per permettere al browser di caricare file più grandi di 2GB </li>
</ul>

<h4>Downloads di qualsiasi dimensione</h4>
<ul>
        <li>E\' necessario un browser recente, <b>non</b> sono richiesti Abobe Flash o HTML5 per il download</li>
		
</ul>

<h4>Upload di file più piccoli di 2 Gigabytes (2GB) con Adobe Flash</h4>
<ul>
        <li>Se visualizzi correttamente YouTube, allora questo metodo dovrebbe funzionare correttamente</li>
        <li>E\' necessario un browser recente per utilizzare la versione 10 (o superiore) di <a target="_blank" href="http://www.adobe.com/software/flash/about/">Adobe Flash.</a></li>
        <li>FileSender ti avviserà se proverai a caricare un file troppo grande con questo metodo</li>
</ul>



<h4>Limiti di questa installazione di Filesender</h4>
<ul>
    <li><strong>
      Massimo numero di destinatari per email:</strong> Fino a '. $config["max_email_recipients"].' destinatari email separati da virgola o punto e virgola</li>
    <li><strong>Massimo numero di file per upload:</strong> uno - per caricare più file contemporaeamente, prima compirimili in un unico archivio</li>
    <li><strong>Massima dimensione del file per upload, con Adobe Flash: </strong>'. formatBytes($config["max_flash_upload_size"]).' </li>
    <li><strong>Massima dimensione del file per upload, con HTML5: </strong>'. formatBytes($config["max_html5_upload_size"]).'</li>
    <li><strong>Massimo numero di giorni per la scadenza del file / voucher: </strong>'. $config["default_daysvalid"].' </li>
</ul>
<p>Per maggiori informazioni visita <a href="http://www.filesender.org/" target="_blank">www.filesender.org</a></p>
</div>
</div>';

// site about
$lang["_ABOUT_TEXT"] = ' <div align="left" style="padding:5px">'. htmlspecialchars($config['site_name']) .' è un\'installazione di FileSender (<a rel="nofollow" href="http://www.filesender.org/" target="_blank">www.filesender.org</a>), sviluppato secondo i requisiti della comunità di ricerca e di istruzione superiore.</div>';

// site AUP terms
$lang["_AUPTERMS"] = 'Termini e condizioni d\'uso';
?>
