<?php

/*
 * FileSender www.filesender.org
 * 
 * Copyright (c) 2009-2012, AARNet, Belnet, HEAnet, SURFnet, UNINETT
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * *	Redistributions of source code must retain the above copyright
 * 	notice, this list of conditions and the following disclaimer.
 * *	Redistributions in binary form must reproduce the above copyright
 * 	notice, this list of conditions and the following disclaimer in the
 * 	documentation and/or other materials provided with the distribution.
 * *	Neither the name of AARNet, Belnet, HEAnet, SURFnet and UNINETT nor the
 * 	names of its contributors may be used to endorse or promote products
 * 	derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* ---------------------------------
 * fr_FR Language File
 * Contributed by Claude Tompers (RESTENA)
 * ---------------------------------
 */
// main menu items
$lang["_ADMIN"] = "Administration";
$lang["_NEW_UPLOAD"] = "Envoyer fichier";
$lang["_VOUCHERS"] = "Inviter une personne";
$lang["_LOGON"] = "Connexion";
$lang["_LOG_OFF"] = "Déconnexion";
$lang["_MY_FILES"] = "Mes fichiers";

// page titles
$lang["_HOME"] = "Accueil";
$lang["_ABOUT"] = "A propos";
$lang["_HELP"] = "Aide";
$lang["_DELETE_VOUCHER"] = "Supprimer le ticket";
$lang["_UPLOAD_COMPLETE"] = "Votre fichier a été téléchargé et un message a été envoyé.";
$lang["_UPLOAD_PROGRESS"] = "Progrès du téléchargement";
$lang["_DOWNLOAD"] = "Téléchargement";
$lang["_CANCEL_UPLOAD"] = "Annuler le téléchargement";

// admin
$lang["_PAGE"] = "Page";
$lang["_UP"] = "Haut";
$lang["_DOWN"] = "Bas";
$lang["_FILES"] = "Fichiers";
$lang["_DRIVE"] = "Disque";
$lang["_TOTAL"] = "Total";
$lang["_USED"] = "Utilisé";
$lang["_AVAILABLE"] = "Disponible";
$lang["_TEMP"] = "Temp"; // as in Temporary files

$lang["_WELCOME"] = "Bienvenue"; 
$lang["_WELCOMEGUEST"] = "Bienvenue"; 

// admin tab names
$lang["_GENERAL"] = "Général";
$lang["_UPLOADS"] = "Téléchargements vers le serveur";
$lang["_DOWNLOADS"] = "Téléchargements depuis le serveur";
$lang["_ERRORS"] = "Erreurs";
$lang["_FILES_AVAILABLE"] = "Fichiers disponibles";
$lang["_ACTIVE_VOUCHERS"] = "Tickets actifs";
$lang["_COMPLETE_LOG"] = "Logs complets";

// Form Fields
$lang["_TO"] = "A";
$lang["_FROM"] = "De";
$lang["_SIZE"] = "Taille";
$lang["_CREATED"] = "Créé";
$lang["_FILE_NAME"] = "Nom de fichier";
$lang["_SUBJECT"] = "Sujet";
$lang["_EXPIRY"] = "Expiration";
$lang["_MESSAGE"] = "Message";
$lang["_TYPE"] = "Type";
			
$lang["_TERMS_OF_AGREEMENT"] = "Conditions générales d'utilisation";
$lang["_SHOW_TERMS"] = "Afficher les conditions";
$lang["_SHOWHIDE"] = "Afficher/Cacher";
$lang["_UPLOADING_WAIT"] = "Téléchargement en cours - veuillez attendre...";
			
// Flash button menu
$lang["_UPLOAD"] = "Envoyer un fichier";
$lang["_BROWSE"] = "Naviguer";
$lang["_CANCEL"] = "Annuler";
$lang["_OPEN"] = "Ouvrir";
$lang["_CLOSE"] = "Fermer";
$lang["_OK"] = "OK";
$lang["_SEND"] = "Envoyer";
$lang["_DELETE"] = "Supprimer";
$lang["_YES"] = "Oui";
$lang["_NO"] = "Non";
			
$lang["_ERROR_CONTACT_ADMIN"] = "Une erreur s'est produite - veuillez contacter votre administrateur.";
$lang["_INVALID_MISSING_EMAIL"] = "Adresse mail non valide ou absente";	
$lang["_INVALID_EXPIRY_DATE"] = "Date d'expiration non valide";	
$lang["_INVALID_FILE"] = "Fichier non valide";	
$lang["_INVALID_FILEVOUCHERID"] = "Fichier ou ID de ticket non valide";	
$lang["_INVALID_FILESIZE_ZERO"] = "La taille de fichier ne peut pas être 0. Veuillez choisir un autre fichier.";
$lang["_INVALID_FILE_EXT"] = "Extension de fichier non valide.";
$lang["_INVALID_TOO_LARGE_1"] = "La taille de fichier ne peut pas être plus grande que";
$lang["_AUTH_ERROR"] = "Vous n'êtes plus authentifié. <br />Votre session est peut-être expirée ou il y a eu une erreur sur le serveur. <br /><br />Veuillez vous authentifier à nouveau et réessayer.";	
$lang["_SELECT_ANOTHER_FILE"] = "Veuillez choisir un autre fichier.";
$lang["_INVALID_VOUCHER"] = "Ce ticket n'est plus valide. <br />Veuillez contacter la personne qui vous a envoyé le ticket.";
$lang["_SELECT_FILE"] = "Choisissez votre fichier.";
$lang["_INVALID_FILE_NAME"] = "Le nom du fichier que vous téléchargez n'est pas valide. Veuillez renommer le fichier et réessayer.";
$lang["_INVALID_SIZE_USEHTML5"] = "Veuillez choisir un autre fichier ou utiliser un navigateur compatible HTML5 pour télécharger des fichiers plus grands.";
$lang["_ACCEPTTOC"] = "J'accepte les conditions générales de ce service.";	
$lang["_AGREETOC"] = "Vous DEVEZ accepter les conditions générales.";
$lang["_FILE_TO_BE_RESENT"] = "Fichier à réenvoyer";
$lang["_ERROR_UPLOADING_FILE"] = "Erreur de téléchargement du fichier";
$lang["_ERROR_SENDING_EMAIL"] = "Une erreur s'est produite lors de l'envoi de votre message, veuillez contacter votre administrateur.";
$lang["_ERROR_INCORRECT_FILE_SIZE"] = "Un problème s'est produit lors du téléchargement de votre fichier. <br />La taille du fichier sur le serveur est différente de celle du fichier original. <br /><br />Veuillez contacter votre administrateur.";
$lang["_MAXEMAILS"] = "Le nombre maximal d'adresses email acceptées est ";
$lang["_INVALID_DATE_FORMAT"] = "Format de date non valide.";
$lang["_DISK_SPACE_ERROR"] = "Il n'y a plus assez d'espace disque. Veuillez contacter l'administrateur du service ou télécharger un fichier plus petit.";
$lang["_ERROR_ATTRIBUTES"] = "Votre founisseur d'identité ne fournit pas les attributs nécessaires. Contactez votre administrateur";
$lang["_PERMISSION_DENIED"] = "Vous n'avez pas la permission de faire ceci.";
// Logout page
$lang["_LOGOUT_COMPLETE"] = "Déconnexion réussie";
			
// vouchers
$lang["_SEND_NEW_VOUCHER"] = "Un ticket permet à une personne quelconque de vous envoyer un fichier.<br />
Pour créer un ticket, entrez une adresse email et cliquez Envoyer ticket.<br />
Une email sera envoyée à la personne avec un lien sur le ticket.";
$lang["_EMAIL_SEPARATOR_MSG"] = "Multiples adresses email séparées par , ou ;";
			
$lang["_NO_FILES"] = "Il n'y a pas de fichiers disponibles pour l'instant.";
$lang["_NO_VOUCHERS"] = "Il n'y a pas de tickets disponibles pour l'instant.";
$lang["_ARE_YOU_SURE"] = "Etes-vous certain ?";
$lang["_DELETE_FILE"] = "Supprimer fichier";
$lang["_EMAIL_SENT"] = "Message envoyé";
$lang["_EXPIRY_DATE"] = "Date d'expiration";
$lang["_FILE_SIZE"] = "Taille de fichier";
$lang["_FILE_RESENT"] = "Fichier réenvoyé";	
$lang["_MESSAGE_RESENT"] = "Message réenvoyé";			
$lang["_ME"] = "Moi";
$lang["_SEND_VOUCHER"] = "Envoyer ticket";
$lang["_RE_SEND_EMAIL"] = "Ré-envoyer email";
$lang["_NEW_RECIPIENT"] = "Ajouter un nouveau destinataire";
$lang["_SEND_VOUCHER_TO"] = "Envoyer ticket à";
$lang["_START_DOWNLOAD"] = "Démarrer téléchargement";
$lang["_VOUCHER_SENT"] = "Ticket envoyé";
$lang["_VOUCHER_DELETED"] = "Ticket supprimé";
$lang["_VOUCHER_CANCELLED"] = "Ce ticket a été annulé.";
$lang["_VOUCHER_USED"] = "Ce ticket a déjà été utilisé.";
$lang["_STARTED_DOWNLOADING"] = "Votre fichier devrait commencer à être téléchargé.";

// files
$lang["_FILE_DELETED"] = "Fichier supprimé";
// steps
$lang["_STEP1"] = "Entrez les adresses email des destinataires";
$lang["_STEP2"] = "Séléctionnez la date d'expiration";
$lang["_STEP3"] = "Choisissez un fichier";
$lang["_STEP4"] = "Cliquez Envoyer";
$lang["_HTML5Supported"] = "Téléchargements de plus de 2GO supportés";
$lang["_HTML5NotSupported"] = "Téléchargements de plus de 2GO non supportés !";			
	
$lang["_OPTIONAL"] = "Optionnel";
			
// confirmation
$lang["_CONFIRM_DELETE_FILE"] = "Etes-vous sûr de vouloir supprimer ce fichier ?";
$lang["_CONFIRM_DELETE_VOUCHER"] = "Etes-vous sûr de vouloir supprimer ce ticket ?";
$lang["_CONFIRM_RESEND_EMAIL"] = "Etes-vous sûr de vouloir ré-envoyer ce courrier ?";

// standard date display format
$lang['datedisplayformat'] = "d/m/Y"; // Format for displaying date/time, use PHP date() format string syntax 

// datepicker localization
$lang["_DP_closeText"] = 'OK'; // Done
$lang["_DP_prevText"] = 'Préc'; //Prev
$lang["_DP_nextText"] = 'Suiv'; // Next
$lang["_DP_currentText"] = 'Aujourd\'hui'; // Today
$lang["_DP_monthNames"] = "['Janvier','Février','Mars','Avril','Mai','Juin','Juillet','Août','Septembre','Octobre','Novembre','Décembre']";
$lang["_DP_monthNamesShort"] = "['Jan', 'Fev', 'Mar', 'Avr', 'Mai', 'Jun','Jul', 'Aou', 'Sep', 'Oct', 'Nov', 'Dec']";
$lang["_DP_dayNames"] = "['Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi']";
$lang["_DP_dayNamesShort"] = "['Dim', 'Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam']";
$lang["_DP_dayNamesMin"] = "['Di','Lu','Ma','Me','Je','Ve','Sa']";
$lang["_DP_weekHeader"] = 'Sem';
$lang["_DP_dateFormat"] = 'dd/mm/yy';
$lang["_DP_firstDay"] = '1';
$lang["_DP_isRTL"] = 'false';
$lang["_DP_showMonthAfterYear"] = 'false';
$lang["_DP_yearSuffix"] = '';

// Login Splash text
$lang["_SITE_SPLASHHEAD"] = "Bienvenu sur ". htmlspecialchars($config['site_name']);
$lang["_SITE_SPLASHTEXT"] = htmlspecialchars($config['site_name']) ." propose un moyen sécurisé pour partager des gros fichiers avec tout le monde! Connectez-vous pour envoyer vos fichiers ou pour inviter vos interlocuteurs à vous en envoyer.";

// Footer to display
$lang["_SITE_FOOTER"] = ""; 

// site help
$lang["_HELP_TEXT"] = '

<div>

<div align="left" style="padding:5px">

<h4>Connexion</h4> 
<ul>
    <li>Si vous ne voyez pas votre institution dans la liste des fournisseurs d\'Identité (IdPs), ou si la connexion avec votre nom d\'utilisateur au sein de votre institution échoue, veuillez contacter votre service informatique local</li>
</ul>

<h4>Téléchargements vers FileSender jusqu\'à 2 Gigaoctets (2GO) avec Adobe Flash</h4>
<ul>
	<li>Si vous êtes capable de regarder des vidéos YouTube, cette méthode devrait fonctionner pour vous</li>
	<li>Vous avez besoin d\'un navigateur moderne qui tourne avec la version 10 (ou supérieure) de <a target="_blank" href="http://www.adobe.com/software/flash/about/">Adobe Flash</a></li>
	<li>FileSender va vous avertir si vous essayez de télécharger un fichier trop gros pour cette méthode</li>
</ul>

<h4>Téléchargements vers FileSender <i>de toutes tailles</i> avec HTML5</h4>
<ul>
    <li>Si vous voyez <img src="images/html5_installed.png" alt="green HTML5 tick" class="textmiddle" style="display:inline" /> dans le coin en haut à droite, cette méthode fonctionne pour vous</li>
	<li>Vous avez besoin d\'un navigateur web très récent qui supporte HTML5, la version la plus récente du "language du web".</li>
	<li>Pour l\'instant Firefox4 (ou supérieur) et Chrome sous Windows, Mac OSX et Linux devraient fonctionner.</li>
	<li>Veuillez utiliser le site web <a href="http://caniuse.com/fileapi" target="_blank">"When can I use..."</a> pour observer le progrès d\'implémentation de la "HTML5 FileAPI" pour tous les navigateurs web majeurs.  En particulier, <a href="http://caniuse.com/filereader" target="_blank">"FileReader API"</a> et <a href="http://caniuse.com/bloburls" target="_blank">"Blob URLs"</a> doivent être marqués en vert clair (=supportés) pour qu\'un navigateur web supporte des fichiers plus gros que 2GO </li>
</ul>

<h4>Téléchargements de FileSender de toutes tailles</h4>
<ul>
    <li>Vous avez besoin d\'un navigateur web récent, vous n\'avez besoin <b>ni</b> d\'Adobe Flash <b>ni</b> de HTML5 pour recevoir des fichiers de FileSender</li>
</ul>


<h4>Limites de cette installation FileSender</h4>
<ul>
    <li><strong>
      Nombre maximal de destinataires email: </strong>'. $config["max_email_recipients"].' adresses email (separées par virgule ou point-virgule)</li>
    <li><strong>Nombre maximal de fichiers par téléchargement :</strong> un fichier - pour télécharger plusieurs fichiers en même temps, \'zippez\' les d\'abord dans une seule archive </li>
    <li><strong>Taille maximale de fichier, pour Adobe Flash : </strong>'. formatBytes($config["max_flash_upload_size"]).' </li>
    <li><strong>Taille maximale de fichier, pour HTML5 : </strong>'. formatBytes($config["max_html5_upload_size"]).'</li>
    <li><strong>Nombre maximal de jours pour l\'expiration de fichiers / tickets : </strong>'. $config["default_daysvalid"].' </li>
</ul>
<p>Pour plus d\'informations, veuillez visiter <a href="http://www.filesender.org/" target="_blank">www.filesender.org</a></p>
</div>
</div>';

// site about
$lang["_ABOUT_TEXT"] = ' <div align="left" style="padding:5px">'. htmlspecialchars($config['site_name']) .' est une installation de FileSender (<a rel="nofollow" href="http://www.filesender.org/" target="_blank">www.filesender.org</a>), dévelopé pour les besoins de la communauté de l\'éducation supérieure et de la recherche.</div>';

// site AUP terms
$lang["_AUPTERMS"] = "Conditions générales d\'utilisation ...";

?>
