<?php

/*
 * FileSender www.filesender.org
 * 
 * Copyright (c) 2009-2012, AARNet, Belnet, HEAnet, SURFnet, UNINETT
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * *	Redistributions of source code must retain the above copyright
 * 	notice, this list of conditions and the following disclaimer.
 * *	Redistributions in binary form must reproduce the above copyright
 * 	notice, this list of conditions and the following disclaimer in the
 * 	documentation and/or other materials provided with the distribution.
 * *	Neither the name of AARNet, Belnet, HEAnet, SURFnet and UNINETT nor the
 * 	names of its contributors may be used to endorse or promote products
 * 	derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* ---------------------------------
 * fi_FI Language File
 * Finnish translation: Tomi.Salmi@csc.fi
 * 2014-04-22 for FileSender version 1.6
 * ---------------------------------
 * 
 */
// main menu items
$lang["_ADMIN"] = "Ylläpito";
$lang["_NEW_UPLOAD"] = "Jaa tiedosto";
$lang["_VOUCHERS"] = "Kutsu";
$lang["_LOGON"] = "Kirjaudu sisään";
$lang["_LOG_OFF"] = "Kirjaudu ulos";
$lang["_MY_FILES"] = "Omat tiedostot";

// page titles
$lang["_HOME"] = "Etusivu";
$lang["_ABOUT"] = "Tietoja";
$lang["_HELP"] = "Apua";
$lang["_DELETE_VOUCHER"] = "Poista kutsu";
$lang["_UPLOAD_COMPLETE"] = "Tiedosto on siirretty ja ilmoitusviesti lähetetty.";
$lang["_UPLOAD_PROGRESS"] = "Siirto käynnissä";
$lang["_DOWNLOADED"] = "Ladattu";
$lang["_DOWNLOAD"] = "Lataa";
$lang["_CANCEL_UPLOAD"] = "Peruuta siirto";

// admin
$lang["_PAGE"] = "Sivu";
$lang["_UP"] = "Up";
$lang["_DOWN"] = "Down";
$lang["_FILES"] = "Tiedostot";
$lang["_DRIVE"] = "Levy";
$lang["_TOTAL"] = "Yhteensä";
$lang["_USED"] = "Käytössä";
$lang["_AVAILABLE"] = "Vapaana";
$lang["_TEMP"] = "Temp"; // as in Temporary files

// Greetings
$lang["_WELCOME"] = "Tervetuloa"; 
$lang["_WELCOMEGUEST"] = "Tervetuloa, vieras";

// admin tab names
$lang["_GENERAL"] = "Yleiset";
$lang["_UPLOADS"] = "Jaetut";
$lang["_DOWNLOADS"] = "Noudetut";
$lang["_ERRORS"] = "Virheet";
$lang["_FILES_AVAILABLE"] = "Saatavilla olevat tiedostot";
$lang["_ACTIVE_VOUCHERS"] = "Aktiiviset kutsut";
$lang["_COMPLETE_LOG"] = "Täydellinen loki";

// Form Fields
$lang["_TO"] = "Vastaanottaja";
$lang["_FROM"] = "Lähettäjä";
$lang["_SIZE"] = "Koko";
$lang["_CREATED"] = "Luotu";
$lang["_FILE_NAME"] = "Tiedosto";
$lang["_SUBJECT"] = "Otsikko";
$lang["_EXPIRY"] = "Poistuu";
$lang["_MESSAGE"] = "Viesti";
$lang["_TYPE"] = "Tyyppi";

$lang["_TERMS_OF_AGREEMENT"] = "Käyttöehdot";
$lang["_SHOW_TERMS"] = "Näytä ehdot";
$lang["_SHOWHIDE"] = "Näytä/piilota";
$lang["_UPLOADING_WAIT"] = "Siirretään tiedostoa...";
$lang["_SHOW_ALL"] = "Näytä/piilota tiedot";
$lang["_DETAILS"] = "Tiedot";

// button labels
$lang["_UPLOAD"] = "Lähetä tiedosto";
$lang["_BROWSE"] = "Selaa";
$lang["_CANCEL"] = "Peruuta";
$lang["_OPEN"] = "Avaa";
$lang["_CLOSE"] = "Sulje";
$lang["_OK"] = "OK";
$lang["_SEND"] = "Lähetä";
$lang["_DELETE"] = "Poista";
$lang["_YES"] = "Kyllä";
$lang["_NO"] = "Ei";

$lang["_ERROR_CONTACT_ADMIN"] = "Tapahtui virhe - ota yhteyttä ylläpitoon.";	
$lang["_INVALID_MISSING_EMAIL"] = "Sähköpostiosoite puuttuu tai on virheellinen";	
$lang["_INVALID_EXPIRY_DATE"] = "Virheellinen voimassaoloaika";	
$lang["_INVALID_FILE"] = "Tiedosto ei kelpaa";	
$lang["_INVALID_FILEVOUCHERID"] = "Virheellinen tiedosto- tai kutsu-ID";	
$lang["_INVALID_FILESIZE_ZERO"] = "Lähetettävän tiedoston koko ei voi olla 0. Valitse toinen tiedosto.";
$lang["_INVALID_FILE_EXT"] = "Sopimaton tiedostopääte.";
$lang["_INVALID_TOO_LARGE_1"] = "Tiedostokoko ei voi olla suurempi kuin";
$lang["_AUTH_ERROR"] = "Autentikoitumisesi ei ole enää voimassa. <br />Sessiosi on saattanut umpeutua tai palvelimella on tapahtunut virhe. <br /><br />Ole hyvä ja kirjaudu uudelleen.";	
$lang["_SELECT_ANOTHER_FILE"] = "Ole hyvä ja kokeile toista tiedostoa.";
$lang["_INVALID_VOUCHER"] = "Tämä kutsu ei ole enää voimassa. <br />Ole hyvä ja ota yhteyttä henkilöön, jolta sait kutsun";
$lang["_SELECT_FILE"] = "Valitse tiedosto";
$lang["_INVALID_FILE_NAME"] = "Valitsemasi tiedoston nimi ei kelpaa. Ole hyvä ja nimeä tiedosto uudelleen.";
$lang["_INVALID_SIZE_USEHTML5"] = "Ole hyvä ja kokeile toista tiedostoa tai käytä HTML5:ttä tukevaa selainta siirtääksesi suurempia tiedostoja.";
$lang["_ACCEPTTOC"] = "Hyväksyn palvelun käyttöehdot.";	
$lang["_AGREETOC"] = "Sinun tulee hyväksyä palvelun käyttöehdot.";
$lang["_FILE_TO_BE_RESENT"] = "Välitettävä tiedosto";
$lang["_ERROR_UPLOADING_FILE"] = "Tiedoston siirrossa tapahtui virhe";
$lang["_ERROR_SENDING_EMAIL"] = "Sähköposti-ilmoitusten lähettämisessä tapahtui virhe. Ole hyvä ja ota yhteyttä ylläpitoon.";
$lang["_ERROR_INCORRECT_FILE_SIZE"] = "Tiedoston siirrossa tapahtui virhe. <br />Tiedoston koko palvelimella ei vastaa alkuperäisen tiedostosi kokoa. <br /><br />Ole hyvä ja ota yhteyttä ylläpitoon.";
$lang["_MAXEMAILS"] = "Suurin sallittu sähköpostiosoitteiden määrä on ";
$lang["_INVALID_DATE_FORMAT"] = "Päivämääräformaatti on virheellinen.";
$lang["_DISK_SPACE_ERROR"] = "Palvelussa ei ole riittävästi vapaata levytilaa. Ole hyvä ja ota yhteyttä ylläpitoon tai siirrä pienempi tiedosto.";
$lang["_ERROR_ATTRIBUTES"] = "Käyttämäsi IdP-palvelin ei välittänyt vaadittuja attribuutteja. Ota yhteyttä oman organisaatiosi ylläpitoon.";
$lang["_PERMISSION_DENIED"] = "Käyttöoikeutesi eivät riitä tämän toiminnon suorittamiseen.";
// Logout page
$lang["_LOGOUT_COMPLETE"] = "Uloskirjautuminen onnistui";

// vouchers
$lang["_SEND_NEW_VOUCHER"] = "Kutsun avulla kuka tahansa voi jakaa FileSenderin avulla tiedoston kenelle tahansa. Luo uusi kutsu syöttämällä sähköpostiosoite, johon tahdot lähettää kertakäyttöisen kutsun.";

// User interaction
$lang["_EMAIL_SEPARATOR_MSG"] = "Erota sähköpostiosoitteet pilkulla tai puolipisteellä";
$lang["_NO_FILES"] = "Ei tiedostoja";
$lang["_NO_VOUCHERS"] = "Ei voimassaolevia kutsuja";
$lang["_ARE_YOU_SURE"] = "Oletko varma?";
$lang["_DELETE_FILE"] = "Poista tiedosto";
$lang["_EMAIL_SENT"] = "Viesti lähetetty";
$lang["_EXPIRY_DATE"] = "Viimeinen<br/>voimassaolopäivä";
$lang["_FILE_SIZE"] = "Tiedoston koko";
$lang["_FILE_RESENT"] = "Tiedoston uudelleenlähetys";
$lang["_MESSAGE_RESENT"] = "Viestin uudelleenlähetys";
$lang["_ME"] = "Minä";
$lang["_SEND_VOUCHER"] = "Lähetä kutsu";
$lang["_RE_SEND_EMAIL"] = "Uudelleenlähetä sähköposti";
$lang["_NEW_RECIPIENT"] = "Lisää uusi vastaanottaja";
$lang["_SEND_VOUCHER_TO"] = "Kutsun vastaanottaja";
$lang["_START_DOWNLOAD"] = "Aloita lataus";
$lang["_VOUCHER_SENT"] = "Kutsu lähetetty";
$lang["_VOUCHER_DELETED"] = "Kutsu poistettu";
$lang["_VOUCHER_CANCELLED"] = "Tämä kutsu on peruutettu.";
$lang["_VOUCHER_USED"] = "Tämä kutsu on jo käytetty.";
$lang["_STARTED_DOWNLOADING"] = "Tiedostolataus alkaa.";
$lang["_FILE_DELETED"] = "Tämä tiedosto on jo poistettu.";

// steps
$lang["_STEP1"] = "Syötä vastaanottajien sähköpostiosoitteet.";
$lang["_STEP2"] = "Aseta tiedostojaon voimassaoloaika.";
$lang["_STEP3"] = "Valitse tiedosto.";
$lang["_STEP4"] = "Klikkaa \"Lähetä\".";
$lang["_HTML5Supported"] = "Yli 2 Gt:n tiedostot: Tuettu!";
$lang["_HTML5NotSupported"] = "Yli 2 Gt:n tiedostot: Ei tuettu!";

$lang["_OPTIONAL"] = "valinnainen";

// confirmation
$lang["_CONFIRM_DELETE_FILE"] = "Tahdotko varmasti poistaa tämän tiedoston?";
$lang["_CONFIRM_DELETE_VOUCHER"] = "Tahdotko varmasti poistaa tämän kutsun?";
$lang["_CONFIRM_RESEND_EMAIL"] = "Tahdotko varmasti lähettää tämän viestin uudelleen?";

// standard date display format
$lang['datedisplayformat'] = "d.m.Y"; // Format for displaying date/time, use PHP date() format string syntax

// datepicker localization
$lang["_DP_closeText"] = 'Valmis'; // Done
$lang["_DP_prevText"] = 'Edellinen'; //Prev
$lang["_DP_nextText"] = 'Seuraava'; // Next
$lang["_DP_currentText"] = 'Tänään'; // Today
$lang["_DP_monthNames"] = "['Tammikuu','Helmikuu','Maaliskuu','Huhtikuu','Toukokuu','Kesäkuu','Heinäkuu','Elokuu','Syyskuu','Lokakuu','Marraskuu','Joulukuu']";
$lang["_DP_monthNamesShort"] = "['Tam', 'Hel', 'Maa', 'Huh', 'Tou', 'Kes','Hei', 'Elo', 'Syy', 'Lok', 'Mar', 'Jou']";
$lang["_DP_dayNames"] = "['Sunnuntai', 'Maanantai', 'Tiistai', 'Keskiviikko', 'Torstai', 'Perjantai', 'Lauantai']";
$lang["_DP_dayNamesShort"] = "['Su', 'Ma', 'Ti', 'Ke', 'To', 'Pe', 'La']";
$lang["_DP_dayNamesMin"] = "['Su','Ma','Ti','Ke','To','Pe','La']";
$lang["_DP_weekHeader"] = 'Vk';
$lang["_DP_dateFormat"] = 'dd.mm.yy';
$lang["_DP_firstDay"] = '1';
$lang["_DP_isRTL"] = 'false';
$lang["_DP_showMonthAfterYear"] = 'false';
$lang["_DP_yearSuffix"] = '';

// Terasender Advanced Settings
$lang["_TERA_ADVANCED_SETTINGS"] = "Lisäasetukset";
$lang["_TERA_CHUNKSIZE"] = "Tiedostopalasten koko (Mt)"; // "Chunksize (MB)";
$lang["_TERA_WORKER_COUNT"] = "Workerien lkm."; // "Worker count";
$lang["_TERA_JOBS_PER_WORKER"] = "Tehtäviä per worker"; // "Jobs per workers";

// Login Splash text
$lang["_SITE_SPLASHHEAD"] = "Tervetuloa palveluun ". htmlspecialchars($config['site_name']);
$lang["_SITE_SPLASHTEXT"] = htmlspecialchars($config['site_name']) ." on turvallinen tapaa jakaa suuriakin tiedostoja kenelle tahansa.";

// Footer to display
$lang["_SITE_FOOTER"] = ""; 

// site help
$lang["_HELP_TEXT"] = '
<div>
<div align="left" style="padding:5px">
<h4>Sisäänkirjautuminen</h4>
<ul>
    <li>Kirjaudu palveluun valitsemalla oman organisaatiosi tunnistuspalvelin. Mikäli sisäänkirjautumisessa on ongelmia, ota yhteyttä oman organisaatiosi IT-tukeen.</li>
</ul>

<h4>Tiedostojen jakaminen HTML5:llä</h4>
<ul>
	<li> Mikäli näet vihreän HTML5-tukea osoittavan merkin <img src="images/html5_installed.png" alt="green HTML5 tick" class="textmiddle" style="display:inline" />,
selaimessasi on riittävä HTML5-tuki suurten tiedostojen siirtoa varten. Jos merkkiä ei näy, käyttämästäsi selaimesta puuttuu riittävä HTML5-tuki.</li>
	<li> Riittävä HTML5-tuki on mm. seuraavissa verkkoselaimissa: Firefox ja Chrome (uudehkot versiot) Windows-, Linux- ja OS X -käyttöjärjestelmissä, Safari 6 tai uudempi Mac OS X 
-käyttöjärjestelmässä ja IE 10 tai uudempi Windows-käyttöjärjestelmässä.</li>
	<li> Tuetulla selaimella pystyt jatkamaan kesken jäänyttä jakoa (upload). Jatkaaksesi siirtoa varmista, että valitset koneeltasi täsmälleen saman tiedoston saman nimisenä, kuin jota aloit siirtää aiemmin. Kun siirto alkaa, huomaat etenemispalkin tilasta minkä verran tiedostoa on kokonaisuudessaan siirretty.<br /><br />
<i>Mikäli muokkasit</i> tiedostoa ensimmäisen ja toisen siirron välissä, uudelleennimeä tiedosto ennen toisen siirron aloittamista. Näin varmistat, että siirrot eivät sekoitu, ja uuden tiedoston siirto alkaa alusta ja onnistuu kokonaisuudessaan.</li>
</ul>

<h4>Tiedostojen noutaminen</h4>
<ul>
	<li>Voit noutaa tiedostoja FileSenderista millä tahansa nykyaikaisella verkkoselaimella. Tähän et tarvitse HTML5- tai Flash-tukea.</li>
</ul>

<h4>Alle kahden gigatavun (2 Gt) tiedostojen siirtäminen käyttäen Flash-tukea</h4>
<ul>
	<li>Jos HTML5-tukea ei ole, voit hyödyntää Adobe Flashia</li>
	<li>Käytä <a target="_blank" href="http://www.adobe.com/software/flash/about/">Adobe Flash</a> -pluginin versiota 10 tai uudempaa</li>
	<li>Adobe Flashia käytettäessä jaettavan tiedoston suurin mahdollinen koko on 2 gigatavua (2 Gt). FileSender varoittaa, mikäli yrität siirtää tätä suurempaa tiedostoa</li>
	<li>Adobe Flash -siirto ei tue aiemmin keskeytyneen latauksen jatkamista</li>
</ul>


<h4>Palveluun määritellyt asetukset</h4>
<ul>
    <li><strong>
      Vastaanottajien maksimimäärä:</strong> Korkeintaan '. $config["max_email_recipients"].' sähköpostiosoitetta pilkulla tai puolipisteellä eroteltuina</li>
    <li><strong>Kerralla siirrettävien tiedostojen maksimimäärä:</strong> Yksi. Mikäli tahdot siirtää useampia tiedostoja kerralla, pakkaa ne yhteen ennen siirtoa FileSenderiin.</li>
    <li><strong>Jaettavan tiedoston maksimikoko Flash-tekniikalla: </strong>'. formatBytes($config["max_flash_upload_size"]).' </li>
    <li><strong>Jaettavan tiedoston maksimikoko HTML5-selaimilla: </strong>'. formatBytes($config["max_html5_upload_size"]).'</li>
    <li><strong>Pisin sallittu säilytysaika (vuorokautta): </strong>'. $config["default_daysvalid"].' </li>
</ul>

<h4>Teknisiä tietoja</h4>
<ul>
	<li><i>'. htmlspecialchars($config['site_name']) .'</i> perustuu avoimen lähdekoodin <a href="http://www.filesender.org/" target="_blank">FileSender-sovellukseen</a>. Sovellus kertoo, tukeeko käyttäjän selain HTML5-siirtoa. Yli 2 Gt kokoisten tiedostojen jakaminen edellyttä riittävää HTML5-tukea, erityisesti HTML5 <a href="http://caniuse.com/filereader" target="_blank">FileReader</a>- ja <a href="http://caniuse.com/bloburls" target="_blank">Blob URLs</a> -tukia. 
</li>
</ul>

<p>Lisätietoja FileSender-sovelluksesta osoitteessa <a href="http://www.filesender.org/" target="_blank">www.filesender.org</a>.</p>
</div>
</div>';

// site about
$lang["_ABOUT_TEXT"] = '
<div align="left" style="padding:5px">'. htmlspecialchars($config['site_name']) .' perustuu FileSender-web-sovellukseen (<a rel="nofollow" href="http://www.filesender.org/" target="_blank">www.filesender.org</a>), joka on kehitetty erityisesti korkeakoulujen ja tutkimusyhteisöjen tarpeisiin.</div>';

// site AUP terms
$lang["_AUPTERMS"] = "Käyttöehdot ...";

?>
