<?php

/*
 * FileSender www.filesender.org
 * 
 * Copyright (c) 2009-2012, AARNet, Belnet, HEAnet, SURFnet, UNINETT
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * *	Redistributions of source code must retain the above copyright
 * 	notice, this list of conditions and the following disclaimer.
 * *	Redistributions in binary form must reproduce the above copyright
 * 	notice, this list of conditions and the following disclaimer in the
 * 	documentation and/or other materials provided with the distribution.
 * *	Neither the name of AARNet, Belnet, HEAnet, SURFnet and UNINETT nor the
 * 	names of its contributors may be used to endorse or promote products
 * 	derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* --------------------------------------------------
 * cs_CZ Language File
 * Contributed and maintained by Lubos Kopecky/CESNET
 * --------------------------------------------------
 */

// main menu items
$lang["_ADMIN"] = "Administrace";
$lang["_NEW_UPLOAD"] = "Nahrát nový soubor";
$lang["_VOUCHERS"] = "Pozvánky";
$lang["_LOGON"] = "Přihlásit";
$lang["_LOG_OFF"] = "Odhlásit";
$lang["_MY_FILES"] = "Mé soubory";

// page titles
$lang["_HOME"] = "Domů";
$lang["_ABOUT"] = "O programu";
$lang["_HELP"] = "Pomoc";
$lang["_DELETE_VOUCHER"] = "Smazat pozvánku";
$lang["_UPLOAD_COMPLETE"] = "Váš soubor byl nahrán a zpráva odeslána.";
$lang["_UPLOAD_PROGRESS"] = "Průběh nahrávání";
$lang["_DOWNLOAD"] = "Stáhnout";
$lang["_CANCEL_UPLOAD"] = "Nahrávání přerušeno";

// admin
$lang["_PAGE"] = "Strana";
$lang["_UP"] = "Nahoru";
$lang["_DOWN"] = "Dolu";
$lang["_FILES"] = "Soubory";
$lang["_DRIVE"] = "Disk";
$lang["_TOTAL"] = "Celkem";
$lang["_USED"] = "Využito";
$lang["_AVAILABLE"] = "Dostupné";
$lang["_TEMP"] = "Dočasné soubory"; // as in Temporary files

$lang["_WELCOME"] = "Vítejte"; 
$lang["_WELCOMEGUEST"] = "Vítejte"; 

// admin tab names
$lang["_GENERAL"] = "Obecné";
$lang["_UPLOADS"] = "Nahráno";
$lang["_DOWNLOADS"] = "Staženo";
$lang["_ERRORS"] = "Chyby";
$lang["_FILES_AVAILABLE"] = "Dostupné soubory";
$lang["_ACTIVE_VOUCHERS"] = "Aktivní pozvánky";
$lang["_COMPLETE_LOG"] = "Kompletní log";


// Form Fields
$lang["_TO"] = "Příjemce";
$lang["_FROM"] = "Odesílatel";
$lang["_SIZE"] = "Velikost";
$lang["_CREATED"] = "Vytvořeno";
$lang["_FILE_NAME"] = "Jméno souboru";
$lang["_SUBJECT"] = "Předmět";
$lang["_EXPIRY"] = "Expirace";
$lang["_MESSAGE"] = "Zpráva";
$lang["_TYPE"] = "Type";

$lang["_TERMS_OF_AGREEMENT"] = "Podmínky užití služby";
$lang["_SHOW_TERMS"] = "Zobrazit podmínky";
$lang["_SHOWHIDE"] = "Zobrazit/Skrýt";
$lang["_UPLOADING_WAIT"] = "Nahrávám soubor - čekejte, prosím...";

// Flash button menu
$lang["_UPLOAD"] = "Nahrát soubor";
$lang["_BROWSE"] = "Procházet";
$lang["_CANCEL"] = "Zrušit";
$lang["_OPEN"] = "Otevřít";
$lang["_CLOSE"] = "Zavřít";
$lang["_OK"] = "OK";
$lang["_SEND"] = "Odeslat";
$lang["_DELETE"] = "Smazat";
$lang["_YES"] = "Ano";
$lang["_NO"] = "Ne";

$lang["_ERROR_CONTACT_ADMIN"] = "Nastala neočekávaná chyba - prosím, kontaktujte svého administrátora.";
$lang["_INVALID_MISSING_EMAIL"] = "Nesprávný vyplněný nebo chybějící email";	
$lang["_INVALID_EXPIRY_DATE"] = "Chybný datum expirace";	
$lang["_INVALID_FILE"] = "Chybný soubor";	
$lang["_INVALID_FILEVOUCHERID"] = "Chybný soubor nebo ID pozvánky";	
$lang["_INVALID_FILESIZE_ZERO"] = "Velikost souboru nemůže být 0. Prosím, vyberte jiný soubor.";
$lang["_INVALID_FILE_EXT"] = "Chybná koncovka souboru.";
$lang["_INVALID_TOO_LARGE_1"] = "Velikost souboru nemůže být více než";
$lang["_AUTH_ERROR"] = "Nejste již přihlášen. <br />Vaše sezení vypršelo nebo nastala chyba serveru. <br /><br />Prosím, přihlašte se znovu.";	
$lang["_SELECT_ANOTHER_FILE"] = "Prosím, vyberte jiný soubor.";
$lang["_INVALID_VOUCHER"] = "Tato pozvánka již není platná. <br />Kontaktujte, prosím, osobu, která Vám pozvánku zaslala";
$lang["_SELECT_FILE"] = "Vyberte soubor";
$lang["_INVALID_FILE_NAME"] = "Jméno nahrávaného souboru je chybné. Přejmenujte, prosím, Váš soubor a zkuste to znovu.";
$lang["_INVALID_SIZE_USEHTML5"] = "Vyberte, prosím, jiný soubor nebo použijte prohlížeč se zapnutou podporou HTML5 pro nahrání velkých souborů.";
$lang["_ACCEPTTOC"] = "Souhlasím s podmínkami užití této služby.";	
$lang["_AGREETOC"] = "Musíte souhlasit s podmínkami užití této služby.";
$lang["_FILE_TO_BE_RESENT"] = "Soubor bude přerozdělen";
$lang["_ERROR_UPLOADING_FILE"] = "Chyba při nahrávání souboru";
$lang["_ERROR_SENDING_EMAIL"] = "Chyba při odesílání souborů, prosím, kontaktujte svého administrátora.";
$lang["_ERROR_INCORRECT_FILE_SIZE"] = "Chyba při odesílání souboru. <br />Velikost souboru na serveru nesouhlasí s velikosti originálního souboru. <br /><br />Prosím, kontaktujte svého administrátora.";
$lang["_MAXEMAILS"] = "Maximálni počet povolených emailových adres je ";
$lang["_INVALID_DATE_FORMAT"] = "Nesprávný formát datumu.";
$lang["_DISK_SPACE_ERROR"] = "Není dostatek místa na disku. Prosím, kontaktujte správce této služby nebo nahrajte menší soubor.";
$lang["_ERROR_ATTRIBUTES"] = "Váš poskytovatel identity (IdP) neposkytl všechny potřebné atributy. Kontaktujte, prosím, svého administrátora.";
$lang["_PERMISSION_DENIED"] = "Nemáte dostatečná oprávnění k vykonání této akce.";

$lang["_LOGOUT_COMPLETE"] = "Odhlášení proběhlo úspěšně";

// vouchers
$lang["_SEND_NEW_VOUCHER"] = "Pomocí pozvánky Vám může jiná osoba zaslat soubor.<br />
Pro vytvoření pozvánky vložte emailovou adresu a vyberte Odeslat pozvánku.<br />
Email s odkazem na pozvánku bude odeslán příjemci.";
$lang["_EMAIL_SEPARATOR_MSG"] = "Více emailových adres je možné oddělit pomocí , nebo ;";

$lang["_NO_FILES"] = "Žádný soubor není momentálně dostupný";
$lang["_NO_VOUCHERS"] = "Žádné pozvánky nejsou v tuto chvíli dostupné.";
$lang["_ARE_YOU_SURE"] = "Jste si jist?";
$lang["_DELETE_FILE"] = "Smazat soubor";
$lang["_EMAIL_SENT"] = "Zpráva odeslána";
$lang["_EXPIRY_DATE"] = "Datum expirace";
$lang["_FILE_SIZE"] = "Velikost souboru";
$lang["_FILE_RESENT"] = "Soubor přeposlán";	
$lang["_MESSAGE_RESENT"] = "Zpráva přeposlána";			
$lang["_ME"] = "Já";
$lang["_SEND_VOUCHER"] = "Odeslat pozvánku";
$lang["_RE_SEND_EMAIL"] = "Znovu odeslat email příjemci";
$lang["_NEW_RECIPIENT"] = "Přidat nového příjemce";
$lang["_SEND_VOUCHER_TO"] = "Odeslat pozvánku na";
$lang["_START_DOWNLOAD"] = "Zahájit stahování";
$lang["_VOUCHER_SENT"] = "Pozvánka odeslána";
$lang["_VOUCHER_DELETED"] = "Pozvánka smazána";
$lang["_VOUCHER_CANCELLED"] = "Tato pozvánka byla zrušena.";
$lang["_VOUCHER_USED"] = "Tato pozvánka již byla použita.";
$lang["_STARTED_DOWNLOADING"] = "Stahování souboru může začít.";

// files
$lang["_FILE_DELETED"] = "Soubor smazán";
// steps
$lang["_STEP1"] = "Vložte emailové adresy příjemců";
$lang["_STEP2"] = "Nastavte datum expirace";
$lang["_STEP3"] = "Vyberte soubor";
$lang["_STEP4"] = "Klikněte na Odeslat";
$lang["_HTML5Supported"] = "Nahrání souboru přesahující 2GB je podporováno!";
$lang["_HTML5NotSupported"] = "Nahrání souboru přesahující 2GB není podporováno!";			

$lang["_OPTIONAL"] = "volitelné";

// confirmation
$lang["_CONFIRM_DELETE_FILE"] = "Jste si jist, že chcete smazat tento soubor?";
$lang["_CONFIRM_DELETE_VOUCHER"] = "Jste si jist, že chcete smazat tuto pozvánku?";
$lang["_CONFIRM_RESEND_EMAIL"] = "Jste si jisti, že chcete znovu odeslat tento email?";

// standard date display format - vouchers, sent files
$lang['datedisplayformat'] = "d. m. Y"; // Format for displaying date/time, use PHP date() format string syntax 

// datepicker localization
$lang["_DP_closeText"] = 'Hotovo'; // Done
$lang["_DP_prevText"] = 'Předchozí'; //Prev
$lang["_DP_nextText"] = 'Další'; // Next
$lang["_DP_currentText"] = 'Dnes'; // Today
$lang["_DP_monthNames"] = "['Leden','Únor','Březen','Duben','Květen','Červen','Červenec','Srpen','Září','Říjen','Listopad','Prosinec']";
$lang["_DP_monthNamesShort"] = "['Led', 'Úno', 'Bře', 'Dub', 'Kvě', 'Čvn','Čvc', 'Srp', 'Zář', 'Říj', 'Lis', 'Pro']";
$lang["_DP_dayNames"] = "['Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota']";
$lang["_DP_dayNamesShort"] = "['Ned', 'Pon', 'Úte', 'Stř', 'Čtv', 'Pát', 'Sob']";
$lang["_DP_dayNamesMin"] = "['Ne','Po','Út','St','Čt','Pá','So']";
$lang["_DP_weekHeader"] = 'Týden';
$lang["_DP_dateFormat"] = 'dd. mm. yy';
$lang["_DP_firstDay"] = '1';
$lang["_DP_isRTL"] = 'false';
$lang["_DP_showMonthAfterYear"] = 'false';
$lang["_DP_yearSuffix"] = '';

// Login Splash text
$lang["_SITE_SPLASHHEAD"] = "Vítejte na ". htmlspecialchars($config['site_name']);
$lang["_SITE_SPLASHTEXT"] = htmlspecialchars($config['site_name']) ." je bezpečná cesta pro sdílení velkých souborů mezi všemi! Přihlaš se a nahraj své soubory nebo pozvi ostatní, ať soubory nahrají oni."; 

// Footer to display
$lang["_SITE_FOOTER"] = ""; 

// site help
$lang["_HELP_TEXT"] = '

<div>

<div align="left" style="padding:5px">

<h4>Přihlásit</h4> 
<ul>
    <li>Pokud nenaleznete Vaší instituci v seznamu Identity providerů (IdPs), nebo přihlášení k Vaší instituci skončí chybou, kontaktujte, prosím, Vaší lokální IT-podporu</li>
</ul>

<h4>Nahrání menšího souboru než 2 Gigabytes (2GB) pomocí Adobe Flash</h4>
<ul>
	<li>Pokud sledujete videa na YouTube, tak by Vám měl tento způsob nahrání souborů fugovat</li>
	<li>Potřebujete moderní prohlížeč s <a target="_blank" href="http://www.adobe.com/software/flash/about/">Adobe Flash</a> verze 10 nebo vyšší.</li>
	<li>FileSender Vás upozorní, pokud se pomocí této metody pokusíte nahrát příliš velký soubor</li>
</ul>

<h4>Nahrát soubor o <i>jakékoliv velikosti</i> pomocí HTML5</h4>
<ul>
        <li>HTML5 je dostupné, pokud vidíte <img src="images/html5_installed.png" alt="green HTML5 tick" class="textmiddle" style="display:inline" /> v horním pravém rohu FileSenderu.</li>
	<li>Potřebujete aktuální prohlížeč podporující HTML5 (poslední verze webového programovacího jazyka).</li>
	<li>Firefox4 (a vyšší) a Chrome na Windows, Mac OSX a Linux HTML5 podporují.</li>
	<li>Prosím, projděte si stránku <a href="http://caniuse.com/fileapi" target="_blank">"When can I use..."</a> pro zjistění stavu implementace HTML5 FileAPI pro všechny hlavní používané prohlížeče. Zejména podpora <a href="http://caniuse.com/filereader" target="_blank">FileReader API</a> a <a href="http://caniuse.com/bloburls" target="_blank">Blob URLs</a> musí být zvýrazněno světle zeleně (=podporováno) pro prohlížeče podporující nahrání souborů větších než 2GB </li>
</ul>

<h4>Stahování jakékoliv velikosti souboru</h4>
<ul>
        <li>Potřebujete moderní prohlížeč, Adobe Flash ani HTML5 <b>nejsou</b> nutné pro stahování</li>
</ul>


<h4>Limity této instalace FileSenderu</h4>
<ul>
    <li><strong>
      Počet emilových adresátů na jedno odeslání: </strong>'. $config["max_email_recipients"].' více emailových adres (odděleny čárkou nebo středníkem)</li>
    <li><strong>Maximální počet souborů na jedno nahrání:</strong> jeden - pro nahrání více souborů najednou je nutné využití zabalení všech souborů do jednoho archivu (např. zip či rar)</li>
    <li><strong>Maximální velikost souboru na jedno nahrání (pouze pro Adobe Flash): </strong>'. formatBytes($config["max_flash_upload_size"]).' </li>
    <li><strong>Maximální velikost souboru na jedno nahrání (pouze pro HTML5): </strong>'. formatBytes($config["max_html5_upload_size"]).'</li>
    <li>      <strong>Maximum počet dní platnosti souborů / pozvánek: </strong>'. $config["default_daysvalid"].' </li>
</ul>
<p>Pro více informací prosím navštivte <a href="http://www.filesender.org/" target="_blank">www.filesender.org</a></p>
</div>
</div>';

// site about
$lang["_ABOUT_TEXT"] = ' <div align="left" style="padding:5px">'. htmlspecialchars($config['site_name']) .' je instalace FileSender (<a rel="nofollow" href="http://www.filesender.org/" target="_blank">www.filesender.org</a>), který je vyvinut pro potřeby vzdělávací a výzkumné komunity.</div>';

$lang["_AUPTERMS"] = "Kompletní znění podmínek užití této služby...";

?>
