<?php

/**
 * @file
 * This template is used to print a single field in a view.
 *
 * It is not actually used in default Views, as this is registered as a theme
 * function which has better performance. For single overrides, the template is
 * perfectly okay.
 *
 * Variables available:
 * - $view: The view object
 * - $field: The field handler object that can process the input
 * - $row: The raw SQL result that can be used
 * - $output: The processed output that will normally be used.
 *
 * When fetching output from the $row, this construct should be used:
 * $data = $row->{$field->field_alias}
 *
 * The above will guarantee that you'll always get the correct data,
 * regardless of any changes in the aliasing that might happen if
 * the view is modified.
 */

$source = $created = NULL;
if (isset($row->metadata_dc['source'][0])) {
  $source = $row->metadata_dc['source'][0];
}
if (isset($row->metadata_qdc['created'][0])) {
  $created = $row->metadata_qdc['created'][0];
}

// If edit right: show video, if created + retention years are past,
// then disable viewing of video.
if ((!$row->access_edit) && (isset($source) && isset($created))) {
  $source_num_years = (int) substr($source, 0, 1);
  if ($source_num_years < 1) {
    $source_num_years = 1;
  }
  if ($source_num_years > 5) {
    $source_num_years = 5;
  }
  $created = strtotime((string) $created);
  $retention_date = date('Y-m-d', strtotime('+' . $source_num_years . ' year', $created));

  if (strtotime($retention_date) < strtotime(date('Y-m-d'))) {
    global $base_url;
    $image = $base_url . '/' . drupal_get_path('theme', 'sitebuilder_uvt') . '/images/notfound.png';
    print '<img src="' . $image . '" width="640px" height="360px" />';
  }
  else {
    print $output;
  }
}
else {
  print $output;
}
?>
