ALTER TABLE nrens ADD COLUMN country CHAR(2) NOT NULL;
ALTER TABLE admins ADD CONSTRAINT UNIQUE(admin,nren);

-- ---------------------------------------------------------
--
-- idp_map
--
-- The IdP-Map is what we use to connect an IdP to an NREN. Since one
-- NREN can contain several IdPs, but one IdP may only belong to a
-- single NRNEN, we reference the NREN from this table.
--
-- The idp_url must match the index used in
-- metadata/saml20-idp-remote.php in SimpleSAMLphp.
-- ---------------------------------------------------------
CREATE TABLE IF NOT EXISTS idp_map (
  -- E.g. https://idp.example.org/
  -- This is the same key as used in the metadata section
  idp_url VARCHAR(128) PRIMARY KEY,
  nren_id INTEGER NOT NULL,

  FOREIGN KEY(nren_id) REFERENCES nrens(nren_id) ON DELETE CASCADE
) engine=InnoDB;

    -- Help-section.
ALTER TABLE subscribers ADD COLUMN subscr_help_url VARCHAR(128) DEFAULT "";
ALTER TABLE subscribers ADD COLUMN subscr_help_email VARCHAR(64) DEFAULT "";

-- -----------------------------------------------------------------------------
-- critical_error
--
-- Store the errors regarded as critical in this table for making error-reporting
-- available to the outside of Confusa
CREATE TABLE IF NOT EXISTS critical_errors (
        errid       INT PRIMARY KEY AUTO_INCREMENT,
        error_date  DATETIME NOT NULL,
        /* more serious errors, higher number. Start a LOG_DEBUG = 0 */
        error_level INT NOT NULL,
        log_msg     TEXT NOT NULL,
        is_resolved BOOLEAN NOT NULL DEFAULT FALSE
) engine=InnoDB;
