#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

package My::Foo;
use Class::Clarity -self;
BEGIN {
	our @EXPORT_OK = qw(foo);
	our @EXPORT = qw(foo);
}
use constant foo => 'Foo';

package My::Bar;
use Class::Clarity -self;
BEGIN {
	our @EXPORT_OK = qw(bar);
}
use constant bar => 'Bar';

package main;

BEGIN {
	use_ok('My::Foo');
	use_ok('My::Bar', qw(bar));
}

ok(eval { foo() }, "Can call foo()");
ok(eval { bar() }, "Can call bar()");

done_testing();
