#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Class::Clarity') or BAIL_OUT('need Class::Clarity to run') }

new_ok('Class::Clarity') or BAIL_OUT('need a Class::Clarity object to run');

package My::Class::Clarity;

use Class::Clarity -self;

BEGIN {
	field foo;
	field bar => {};
	field baz => [[], {}, \[], \{}, undef, \my $lol, qr{^}, \&Class::Clarity::self, \*STDIN];
	field bbq => sub { ++our $i };
	weakfield wat;
	weakfield zomg => sub { my $x = ++our $j; \$x };
}

package main;

sub makeref { my $x = shift; return \$x }

my $c = new My::Class::Clarity;

eval { $c->foo };
like($@, qr/uninitialized/, "Using uninitalized foo should throw an error");
$c->foo(undef);
ok(eval { $c->foo; 1 }, "Using initialized foo should not throw an error");

is_deeply($c->bar, {}, "Simple initializer");
is_deeply($c->baz, [[], {}, \[], \{}, undef, \my $wut, qr{^}, \&Class::Clarity::self, \*STDIN], "Complex initializer");

ok(!$c->bbq_isset, "_isset should be false at first");
is($c->bbq, 1, "Initializer should be called");
is($c->bbq, 1, "Initializer should be called only once");
$c->bbq_reset;
is($c->bbq, 2, "Initializer should be called seperately");
ok($c->bbq_isset, "_isset should be true after initialization");

# plain weakfield
like(do { local $@; eval { $c->wat }; $@ }, qr/uninitialized/, "uninitialized weakfield should fail");
$c->wat(undef);
is(eval { $c->wat; 1 }, 1, "initialized weakfield should not fail");

# weakfield with initializer
my $z = $c->zomg;
is_deeply($z, makeref(1), "weak field, first access");
is_deeply($c->zomg, makeref(1), "weak field, second access");
undef $z;
is_deeply($c->zomg, makeref(2), "weak field, first access after reference undef");

done_testing();
