/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UninitializedMessageException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractMessageLite
implements MessageLite {
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder codedBuilder = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(codedBuilder.getCodedOutput());
            return codedBuilder.build();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", iOException);
        }
    }

    public byte[] toByteArray() {
        try {
            byte[] byArray = new byte[this.getSerializedSize()];
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(byArray);
            this.writeTo(codedOutputStream);
            codedOutputStream.checkNoSpaceLeft();
            return byArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", iOException);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int n = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    public void writeDelimitedTo(OutputStream outputStream) throws IOException {
        int n = this.getSerializedSize();
        int n2 = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(n) + n);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n2);
        codedOutputStream.writeRawVarint32(n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        public BuilderType mergeFrom(CodedInputStream codedInputStream) throws IOException {
            return (BuilderType)this.mergeFrom(codedInputStream, ExtensionRegistryLite.getEmptyRegistry());
        }

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

        public BuilderType mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", iOException);
            }
        }

        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = byteString.newCodedInput();
                this.mergeFrom(codedInputStream, extensionRegistryLite);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", iOException);
            }
        }

        public BuilderType mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(byArray, 0, byArray.length);
        }

        public BuilderType mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
                this.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)this.mergeFrom(byArray, 0, byArray.length, extensionRegistryLite);
        }

        public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            try {
                CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray, n, n2);
                this.mergeFrom(codedInputStream, extensionRegistryLite);
                codedInputStream.checkLastTagWas(0);
                return (BuilderType)this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", iOException);
            }
        }

        public BuilderType mergeFrom(InputStream inputStream) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            this.mergeFrom(codedInputStream, extensionRegistryLite);
            codedInputStream.checkLastTagWas(0);
            return (BuilderType)this;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                return false;
            }
            int n2 = CodedInputStream.readRawVarint32(n, inputStream);
            LimitedInputStream limitedInputStream = new LimitedInputStream(inputStream, n2);
            this.mergeFrom(limitedInputStream, extensionRegistryLite);
            return true;
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            return this.mergeDelimitedFrom(inputStream, ExtensionRegistryLite.getEmptyRegistry());
        }

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite messageLite) {
            return new UninitializedMessageException(messageLite);
        }

        protected static <T> void addAll(Iterable<T> iterable, Collection<? super T> collection) {
            for (T t : iterable) {
                if (t != null) continue;
                throw new NullPointerException();
            }
            if (iterable instanceof Collection) {
                Iterator<T> iterator = (Collection)iterable;
                collection.addAll((Collection<T>)((Object)iterator));
            } else {
                for (T t : iterable) {
                    collection.add(t);
                }
            }
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            LimitedInputStream(InputStream inputStream, int n) {
                super(inputStream);
                this.limit = n;
            }

            public int available() throws IOException {
                return Math.min(super.available(), this.limit);
            }

            public int read() throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n = super.read();
                if (n >= 0) {
                    --this.limit;
                }
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (this.limit <= 0) {
                    return -1;
                }
                int n3 = super.read(byArray, n, n2 = Math.min(n2, this.limit));
                if (n3 >= 0) {
                    this.limit -= n3;
                }
                return n3;
            }

            public long skip(long l) throws IOException {
                long l2 = super.skip(Math.min(l, (long)this.limit));
                if (l2 >= 0L) {
                    this.limit = (int)((long)this.limit - l2);
                }
                return l2;
            }
        }
    }
}

