#! /usr/bin/env perl

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST' or die "open(MANIFEST): $!\n";
	find({wanted => sub { return unless -f; print $fh "$_\n" or die "write(MANIFEST): $!\n" }, no_chdir => 1, follow => 0 }, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	dist_name => 'brebo',
	dist_version => '1.1',
	dist_abstract => 'Check uploaded files',
	dist_author => 'Wessel Dankers <wsl@fruit.je>',
	module_name => 'UvT::Brebo',
	license => 'perl',
	script_files => [],
	create_makefile_pl => 'small',
);
$build->create_build_script;
