/* $Id: bindv6only.c 42664 2014-12-08 14:17:23Z wsl $ */
/* $URL: https://svn.uvt.nl/its-id/trunk/sources/bindv6only/bindv6only.c $ */

#define _GNU_SOURCE

#include <unistd.h>
#include <dlfcn.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#if defined(__SOCKADDR_ALLTYPES) || defined(__CONST_SOCKADDR_ARG)
#define SA_FAMILY(sa) (((const struct sockaddr *)((sa).__sockaddr__))->sa_family)
#else
#define __CONST_SOCKADDR_ARG const struct sockaddr
#define SA_FAMILY(sa) ((sa)->ss_family)
#endif

static int (*libc_bind)(int, __CONST_SOCKADDR_ARG, socklen_t) = NULL;

extern void libbindv6only_init(void);

__attribute__((constructor))
void libbindv6only_init(void) {
	const char *error;
	dlerror();
	libc_bind = dlsym(RTLD_NEXT, "bind");
	error = dlerror();
	if(error)
		(void)write(STDERR_FILENO, error, strlen(error));
}

int bind(int fd, __CONST_SOCKADDR_ARG sa, socklen_t sa_len) {
	int toggle = 1;
	if(libc_bind) {
		if(SA_FAMILY(sa) == AF_INET6
		&& setsockopt(fd, IPPROTO_IPV6, IPV6_V6ONLY, &toggle, sizeof toggle) == -1)
			return -1;

		return libc_bind(fd, sa, sa_len);
	}
	errno = ENOSYS;
	return -1;
}
