# $Id: Request.pm 39148 2013-03-27 14:48:15Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Request;

use Aselect::Request -self;
use Time::HiRes qw(sleep);

param username => sub {
	return unless defined;
	s/\s+//g;
	$_ = lc;
};

param password;

field message => undef;

const uid => sub {
	my $self = shift;

	return undef unless $self->lt;

	my $username = $self->username;
	my $password = $self->password;

	return undef unless $username && $password;

	my $uid = eval { $self->dir->authenticate($username, $password) };
	die $self->errorpage('backend', $@, username => $username) if $@;
	if(defined $uid) {
		warn "Successfully authenticated as '$uid' using password\n";
	} else {
		$self->message('credentials');
		sleep($self->cfg->authfail_timeout);
	}

	return $uid;
};
