# $Id: Confirm.pm 42301 2014-09-26 14:37:50Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Confirm.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Confirm;

use Aselect::UI::Document -self;

use constant rootname => 'confirm-logout';

sub build {
	my $req = $self->req;

	my $logout = $self->construct('logout' =>
		[warn => $req->effective_warn],
	);

	if(my $service = $req->service) {
		$logout->appendTextChild(service => $service);
	}

	if(my $url = $req->back_url) {
		$logout->appendTextChild(url => $url);
	}

	$self->documentElement->appendChild($logout);
}
