# $Id: GSSAPI.pm 43505 2015-07-02 15:10:35Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/GSSAPI.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::GSSAPI;

use GSSAPI;

use Clarity -self;

field cfg;

sub checked() {
	my ($name, $status) = @_;
	return if $status;
	return unless defined $status;
	my $generic = $status->generic_message;
	my $specific = $status->specific_message;
	# controlled detonation:
	do {
		local $@;
		eval { undef $status; undef };
	};
	die "[$name] $generic: $specific\n";
}

field principal => sub { shift->cfg->kerberos_principal };

const credentials => sub {
	my $self = shift;

	my ($scred, $stime);
	eval { checked("gss_acquire_cred", GSSAPI::Cred::acquire_cred($self->principal, GSS_C_INDEFINITE, GSS_C_NO_OID_SET, GSS_C_ACCEPT, $scred, $stime, undef)) };
	# controlled detonation:
	do {
		local $@;
		eval { undef $stime; undef };
		eval { undef $scred; undef };
	};
	die $@ if $@;

	return $scred;
};

sub authenticate {
	my $blob = shift;

	my $context = new GSSAPI::Context;
	my ($gss_client_name, $out_mech, $gss_output_token, $out_flags, $out_time, $gss_delegated_cred, $tname);
	my ($uid, $org) = eval {
		checked("gss_accept_sec_context", $context->accept($self->credentials, $blob, GSS_C_NO_CHANNEL_BINDINGS, $gss_client_name, $out_mech, $gss_output_token, $out_flags, $out_time, $gss_delegated_cred));
		checked("gss_client_name_display", $gss_client_name->display($tname));
		split('@', $tname, 2);
	};
	# controlled detonation:
	do {
		local $@;
		eval { undef $tname; undef };
		eval { undef $gss_delegated_cred; undef };
		eval { undef $out_time; undef };
		eval { undef $out_flags; undef };
		eval { undef $gss_output_token; undef };
		eval { undef $out_mech; undef };
		eval { undef $gss_client_name; undef };
		eval { undef $context; undef };
	};
	die $@ if $@;

	return $org, $uid;
}
