# $Id: Document.pm 42299 2014-09-26 14:30:54Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Success/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Success::Document;

use Aselect::UI::Login::Document -self;

use constant rootname => 'login-success';

sub build {
	if(my $exp = $self->req->expiration_warning) {
		my $el = $self->construct('expiration');
		while(my ($key, $vals) = each %$exp) {
			foreach my $val (@$vals) {
				$el->appendChild($self->construct($key => $val));
			}
		}
		$self->documentElement->appendChild($el);
	}
}

sub response {
	my $res = super;

	my $req = $self->req;

	if($req->redirect_ok) {
		$res->status(302);
		$res->setheader('Location' => $req->cred_url);
	}

	return $res;
}
