# $Id: Password.pm 37889 2012-09-28 10:04:21Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password;

use Aselect::UI::Password::Request;
use Aselect::UI::Password::Document;

use Aselect::Handler -self;

field success;
field authfail_timeout => sub { shift->cfg->authfail_timeout };

sub handle {
	my $req = new Aselect::UI::Password::Request(cfg => $self, ctx => shift);
	return if $req->gateway;
	return $self->success->handle($req) if defined $req->uid;
	my $doc = new Aselect::UI::Password::Document(req => $req);
	return $doc->response;
}
