# cx_Oracle version 7.3

cx_Oracle is a Python extension module that enables access to Oracle
Database.  It conforms to the [Python database API 2.0
specification][1] with a considerable number of additions and a couple
of exclusions.  See the
[homepage](https://oracle.github.io/python-cx_Oracle/index.html) for a
feature list.

cx_Oracle 7 has been tested with Python version 2.7, and with versions 3.5
through 3.8. You can use cx_Oracle with Oracle 11.2, 12.1 and 12.2, 18c and 19c
client libraries. Oracle's standard client-server version interoperability
allows connection to both older and newer databases. For example Oracle 19c
client libraries can connect to Oracle Database 11.2.

## Installation

See [cx_Oracle Installation][15].

## Documentation

See the [cx_Oracle Documentation][2] and [Release Notes][14].

## Samples

See the [/samples][12] directory and the [tutorial][6].  You can also
look at the scripts in [cx_OracleTools][7] and the modules in
[cx_PyOracleLib][8].

## Help

Issues and questions can be raised with the cx_Oracle community on
[GitHub][9] or on the [mailing list][5].

## Tests

See [/test][11].

## Contributing

See [CONTRIBUTING](https://github.com/oracle/python-cx_Oracle/blob/master/CONTRIBUTING.md)

## License

cx_Oracle is licensed under a BSD license which you can find [here][3].

[1]: https://www.python.org/dev/peps/pep-0249
[2]: http://cx-oracle.readthedocs.io
[3]: https://github.com/oracle/python-cx_Oracle/blob/master/LICENSE.txt
[5]: http://lists.sourceforge.net/lists/listinfo/cx-oracle-users
[6]: https://github.com/oracle/python-cx_Oracle/tree/master/samples/tutorial
[7]: http://cx-oracletools.sourceforge.net
[8]: http://cx-pyoraclelib.sourceforge.net
[9]: https://github.com/oracle/python-cx_Oracle/issues
[11]: https://github.com/oracle/python-cx_Oracle/tree/master/test
[12]: https://github.com/oracle/python-cx_Oracle/tree/master/samples
[14]: https://cx-oracle.readthedocs.io/en/latest/release_notes.html
[15]: https://cx-oracle.readthedocs.io/en/latest/user_guide/installation.html
